/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolSubmitActionServiceImpl
implements ProtocolSubmitActionService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SUBMIT_TO_IRB = "Submitted to IRB";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private ProtocolFinderDao protocolFinderDao;
    private BusinessObjectService businessObjectService;
    private ProtocolAssignReviewersService protocolAssignReviewersService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolAssignReviewersService(ProtocolAssignReviewersService protocolAssignReviewersService) {
        this.protocolAssignReviewersService = protocolAssignReviewersService;
    }

    public int getTotalSubmissions(Protocol protocol) {
        int totalSubmissions = 0;
        for (ProtocolSubmission protocolSubmission : this.getProtocolSubmissions(protocol.getProtocolNumber())) {
            int submissionNumber = protocolSubmission.getSubmissionNumber();
            if (submissionNumber <= totalSubmissions || protocolSubmission.getSequenceNumber() > protocol.getSequenceNumber()) continue;
            totalSubmissions = submissionNumber;
        }
        return totalSubmissions;
    }

    public List<ProtocolSubmission> getProtocolSubmissions(String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PROTOCOL_NUMBER, protocolNumber);
        Collection submissions = this.businessObjectService.findMatching(ProtocolSubmission.class, fieldValues);
        return new ArrayList<ProtocolSubmission>(submissions);
    }

    public List<ProtocolSubmission> getProtocolSubmissions(String protocolNumber, int submissionNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(PROTOCOL_NUMBER, protocolNumber);
        fieldValues.put(SUBMISSION_NUMBER, submissionNumber);
        Collection submissions = this.businessObjectService.findMatching(ProtocolSubmission.class, fieldValues);
        return new ArrayList<ProtocolSubmission>(submissions);
    }

    private List<ProtocolSubmission> getProtocolSubmissionsLookupList(String protocolNumber, List<ProtocolSubmission> protocolSubmissionList) throws Exception {
        List<ProtocolSubmission> submissions = protocolSubmissionList;
        ArrayList<ProtocolSubmission> protocolSubmissionLookupDataList = new ArrayList<ProtocolSubmission>();
        for (ProtocolSubmission protocolSubmissionData : submissions) {
            if (!protocolNumber.equals(protocolSubmissionData.getProtocolNumber())) continue;
            protocolSubmissionLookupDataList.add(protocolSubmissionData);
        }
        HashSet<Integer> submissionNumberList = new HashSet<Integer>();
        ArrayList protocolSubmissionLookupResult = new ArrayList();
        for (ProtocolSubmission protocolSubmissionResult : protocolSubmissionLookupDataList) {
            submissionNumberList.add(protocolSubmissionResult.getSubmissionNumber());
        }
        for (Integer submissionNumber : submissionNumberList) {
            ArrayList<ProtocolSubmission> submissionList = null;
            int submissionSequenceNumber = 0;
            for (ProtocolSubmission protocolsubmissionData : protocolSubmissionLookupDataList) {
                if (!protocolsubmissionData.getSubmissionNumber().equals(submissionNumber) || protocolsubmissionData.getSequenceNumber() < submissionSequenceNumber) continue;
                submissionSequenceNumber = protocolsubmissionData.getSequenceNumber();
                submissionList = new ArrayList<ProtocolSubmission>();
                submissionList.add(protocolsubmissionData);
            }
            if (submissionList == null) continue;
            protocolSubmissionLookupResult.add(submissionList.get(0));
        }
        return new ArrayList<ProtocolSubmission>(protocolSubmissionLookupResult);
    }

    public List<ProtocolSubmission> getProtocolSubmissionsLookupData(List<ProtocolSubmission> protocolSubmissionList) throws Exception {
        List<ProtocolSubmission> submissions = protocolSubmissionList;
        ArrayList protocolSubmissionsLookupResult = new ArrayList();
        HashSet<String> submissionProtocolNumberList = new HashSet<String>();
        for (ProtocolSubmission protocolSubmissionData : submissions) {
            submissionProtocolNumberList.add(protocolSubmissionData.getProtocolNumber());
        }
        for (String submissionProtocolNumber : submissionProtocolNumberList) {
            List protocolSubmissionLookupList = null;
            protocolSubmissionLookupList = this.getProtocolSubmissionsLookupList(submissionProtocolNumber, protocolSubmissionList);
            if (protocolSubmissionLookupList == null || protocolSubmissionLookupList.size() <= 0) continue;
            protocolSubmissionsLookupResult.addAll(protocolSubmissionLookupList);
        }
        return new ArrayList<ProtocolSubmission>(protocolSubmissionsLookupResult);
    }

    public void submitToIrbForReview(Protocol protocol, ProtocolSubmitAction submitAction) throws Exception {
        String prevSubmissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
        String submissionTypeCode = protocol.getProtocolSubmission().getSubmissionTypeCode();
        ProtocolSubmission submission = this.createProtocolSubmission(protocol, submitAction);
        if (protocol.getInitialSubmissionDate() == null) {
            protocol.setInitialSubmissionDate(new Date(submission.getSubmissionDate().getTime()));
        }
        this.protocolAssignReviewersService.assignReviewers((ProtocolSubmissionBase)submission, submitAction.getReviewers());
        ProtocolAction protocolAction = new ProtocolAction(protocol, submission, "101");
        protocolAction.setComments(SUBMIT_TO_IRB);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatus);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocol.getProtocolActions().add(protocolAction);
        ProtocolStatus protocolStatus = new ProtocolStatus();
        protocolStatus.setProtocolStatusCode("101");
        protocolStatus.setDescription(SUBMIT_TO_IRB);
        protocol.setProtocolStatus((ProtocolStatusBase)protocolStatus);
        protocol.setProtocolStatusCode("101");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)protocolAction, (ProtocolBase)protocol);
        if (submission.getScheduleIdFk() != null) {
            this.updateDefaultSchedule(submission);
        }
        this.businessObjectService.delete(protocol.getProtocolDocument().getPessimisticLocks());
        protocol.getProtocolDocument().getPessimisticLocks().clear();
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        protocol.refresh();
    }

    protected void updateDefaultSchedule(ProtocolSubmission submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        fieldValues.put("scheduleIdFk", CommitteeSchedule.DEFAULT_SCHEDULE_ID.toString());
        List minutes = (List)this.businessObjectService.findMatching(CommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinute minute : minutes) {
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    protected void addActionToOriginalProtocol(String type, String origProtocolNumber, Integer submissionNumber) throws WorkflowException {
        String protocolNumber = origProtocolNumber.substring(0, 10);
        String index = origProtocolNumber.substring(11);
        Protocol protocol = this.protocolFinderDao.findCurrentProtocolByNumber(protocolNumber);
        ProtocolAction protocolAction = new ProtocolAction(protocol, null, "101");
        protocolAction.setComments(type + "-" + index + ": " + SUBMIT_TO_IRB);
        protocolAction.setSubmissionNumber(submissionNumber);
        protocol.getProtocolActions().add(protocolAction);
        this.businessObjectService.save((PersistableBusinessObject)protocol);
    }

    protected ProtocolSubmission createProtocolSubmission(Protocol protocol, ProtocolSubmitAction submitAction) {
        ProtocolSubmissionBuilder submissionBuilder = new ProtocolSubmissionBuilder(protocol, submitAction.getSubmissionTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(submitAction.getSubmissionQualifierTypeCode());
        submissionBuilder.setProtocolReviewTypeCode(submitAction.getProtocolReviewTypeCode());
        this.setSubmissionStatus(submissionBuilder, submitAction);
        this.setCommittee(submissionBuilder, submitAction);
        this.setSchedule(submissionBuilder, submitAction);
        this.addCheckLists(submissionBuilder, submitAction);
        return submissionBuilder.create();
    }

    protected void setSubmissionStatus(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        if (StringUtils.isBlank((String)submitAction.getNewCommitteeId())) {
            submissionBuilder.setSubmissionStatus("102");
        } else {
            submissionBuilder.setSubmissionStatus("100");
        }
    }

    protected void setCommittee(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        submissionBuilder.setCommittee(submitAction.getNewCommitteeId());
    }

    protected void setSchedule(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        submissionBuilder.setSchedule(submitAction.getNewScheduleId());
    }

    protected void addCheckLists(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        if (this.isProtocolReviewType(submitAction, "3")) {
            this.addExemptStudiesCheckList(submissionBuilder, submitAction);
        } else if (this.isProtocolReviewType(submitAction, "2")) {
            this.addExpeditedReviewCheckList(submissionBuilder, submitAction);
        }
    }

    protected boolean isProtocolReviewType(ProtocolSubmitAction submitAction, String protocolReviewTypeCode) {
        return StringUtils.equals((String)submitAction.getProtocolReviewTypeCode(), (String)protocolReviewTypeCode);
    }

    protected void addExemptStudiesCheckList(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        for (ExemptStudiesCheckListItem item : submitAction.getExemptStudiesCheckList()) {
            if (!item.getChecked()) continue;
            submissionBuilder.addExemptStudiesCheckListItem(item.getExemptStudiesCheckListCode());
        }
    }

    protected void addExpeditedReviewCheckList(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction action) {
        for (ExpeditedReviewCheckListItem item : action.getExpeditedReviewCheckList()) {
            if (!item.getChecked()) continue;
            submissionBuilder.addExpeditedReviewCheckListItem(item.getExpeditedReviewCheckListCode());
        }
    }
}

