/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Watermark;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidWatermarkStatusMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        Watermark watermark = (Watermark)document.getNewMaintainableObject().getDataObject();
        if (watermark.getWatermarkType().equalsIgnoreCase("TEXT") && watermark.getWatermarkText() == null) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("document.newMaintainableObject.watermarkText", "error.watermark.text.required", new String[0]);
            result = false;
        }
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            if (document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                Watermark oldWatermarkDocument = (Watermark)document.getOldMaintainableObject().getDataObject();
                if (watermark.getWatermarkType().equalsIgnoreCase("IMAGE") && watermark.getWatermarkText() == null) {
                    result = true;
                }
                if (!oldWatermarkDocument.getStatusCode().equals(watermark.getStatusCode())) {
                    result &= this.validateWatermarkStatusCode(watermark.getStatusCode());
                }
            } else {
                result &= this.validateWatermarkStatusCode(watermark.getStatusCode());
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean validateWatermarkStatusCode(String watermarkStatusCode) {
        boolean valid = true;
        if (watermarkStatusCode != null && StringUtils.isNotBlank((String)watermarkStatusCode)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("statusCode", watermarkStatusCode);
            int watermarkMatchingCount = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).countMatching(Watermark.class, pkMap);
            if (watermarkMatchingCount > 0) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.statusCode", "error.watermark.statuscode.exists", new String[]{watermarkStatusCode});
                valid = false;
            }
        }
        return valid;
    }
}

