/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;

public class GenericProtocolAuthorizer
extends ProtocolAuthorizer {
    public static final String CLOSE_PROTOCOL = "protocolClose";
    public static final String CLOSE_ENROLLMENT_PROTOCOL = "protocolCloseEnrollment";
    public static final String EXPIRE_PROTOCOL = "protocolExpire";
    public static final String PERMIT_DATA_ANALYSIS = "protocolPermitDataAnalysis";
    public static final String REOPEN_PROTOCOL = "protocolReopen";
    public static final String SUSPEND_PROTOCOL = "protocolSuspend";
    public static final String SUSPEND_PROTOCOL_BY_DSMB = "protocolSuspendByDsmb";
    public static final String TERMINATE_PROTOCOL = "protocolTerminate";
    private static final Map<String, String> TASK_NAME_TO_ACTION_TYPE_MAP = new HashMap();
    private static final String ERROR_MESSAGE = "Please set genericTaskName with one of the static strings in this class.";
    private String genericTaskName;

    public boolean isAuthorized(String userId, ProtocolTask task) {
        return this.canExecuteAction((ProtocolBase)task.getProtocol(), this.convertGenericTaskNameToProtocolActionType()) && this.hasPermission(userId, (ProtocolBase)task.getProtocol(), "Maintain Protocol Submissions");
    }

    String convertGenericTaskNameToProtocolActionType() {
        if (TASK_NAME_TO_ACTION_TYPE_MAP.containsKey(this.genericTaskName)) {
            return (String)TASK_NAME_TO_ACTION_TYPE_MAP.get(this.genericTaskName);
        }
        throw new IllegalArgumentException(ERROR_MESSAGE);
    }

    public void setGenericTaskName(String genericTaskName) {
        if (!TASK_NAME_TO_ACTION_TYPE_MAP.containsKey(genericTaskName)) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        this.genericTaskName = genericTaskName;
    }

    static {
        TASK_NAME_TO_ACTION_TYPE_MAP.put(CLOSE_PROTOCOL, "300");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(CLOSE_ENROLLMENT_PROTOCOL, "207");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(EXPIRE_PROTOCOL, "305");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(PERMIT_DATA_ANALYSIS, "211");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(REOPEN_PROTOCOL, "212");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(SUSPEND_PROTOCOL, "302");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(SUSPEND_PROTOCOL_BY_DSMB, "306");
        TASK_NAME_TO_ACTION_TYPE_MAP.put(TERMINATE_PROTOCOL, "301");
    }
}

