/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.document.Document;

public class ProtocolAssignReviewersAuthorizer
extends ProtocolAuthorizer {
    public boolean isAuthorized(String username, ProtocolTask task) {
        Protocol protocol = task.getProtocol();
        return this.isOnNode(protocol) && this.isPendingOrSubmittedToCommittee(protocol) && (this.isInSchedule(protocol) || this.isExpeditedSubmission(protocol)) && this.hasPermission(username, (ProtocolBase)protocol, "Perform IRB Actions on a Protocol");
    }

    public boolean isOnNode(Protocol protocol) {
        return this.kraWorkflowService.isDocumentOnNode((Document)protocol.getProtocolDocument(), "IRBReview");
    }

    private boolean isPendingOrSubmittedToCommittee(Protocol protocol) {
        return this.findSubmission(protocol) != null;
    }

    private boolean isInSchedule(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmission(protocol);
        return submission != null && !StringUtils.isBlank((String)submission.getCommitteeId()) && !StringUtils.isBlank((String)submission.getScheduleId());
    }

    private ProtocolSubmission findSubmission(Protocol protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"100")) continue;
            return (ProtocolSubmission)submission;
        }
        return null;
    }

    private boolean isExpeditedSubmission(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmission(protocol);
        return submission != null && "2".equals(submission.getProtocolReviewTypeCode());
    }
}

