/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.Collections;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.krad.document.Document;

public class ProtocolAssignReviewersCmtSelAuthorizer
extends ProtocolAuthorizer {
    public boolean isAuthorized(String username, ProtocolTask task) {
        Protocol protocol = task.getProtocol();
        return (this.isOnNode(protocol) || this.willBeOnNode(username, protocol)) && this.hasPermission(username, (ProtocolBase)protocol, "Perform IRB Actions on a Protocol");
    }

    public boolean isOnNode(Protocol protocol) {
        return this.kraWorkflowService.isDocumentOnNode((Document)protocol.getProtocolDocument(), "IRBReview");
    }

    public boolean willBeOnNode(String username, Protocol protocol) {
        boolean results = true;
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)protocol.getProtocolDocument().getDocumentNumber());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(username));
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        try {
            DocumentDetail results1 = info.executeSimulation(reportCriteriaBuilder.build());
            for (ActionRequest actionRequest : results1.getActionRequests()) {
                if (!"DepartmentReview".equals(actionRequest.getNodeName())) continue;
                results = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return results;
    }
}

