/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -8742664470188406956L;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        String userId = user.getPrincipalId();
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            if (this.canCreateProtocol(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteProtocolTask(userId, protocolDocument, "modifyProtocol")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteProtocolTask(userId, protocolDocument, "viewProtocol")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteProtocolTask(userId, protocolDocument, "maintainProtocolOnlineReviews")) {
                editModes.add("maintainProtocolOnlineReviews");
            }
            if (this.canViewReviewComments((Document)protocolDocument, user)) {
                editModes.add("viewReviewComments");
            }
        }
        return editModes;
    }

    public boolean canViewReviewComments(Document document, Person user) {
        ProtocolDocument protocolDoc = (ProtocolDocument)document;
        List participants = protocolDoc.getProtocol().getProtocolPersons();
        for (ProtocolPersonBase participant : participants) {
            String statusCode;
            if (!StringUtils.equalsIgnoreCase((String)(participant.getPersonId() + ""), (String)user.getPrincipalId()) || !(statusCode = protocolDoc.getProtocol().getProtocolStatusCode()).equalsIgnoreCase("101")) continue;
            return false;
        }
        return true;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get("onAmendAndRenewAllowNewProtocolDocument") != null) {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
            return true;
        }
        return this.canCreateProtocol(user);
    }

    public boolean canOpen(Document document, Person user) {
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            return this.canCreateProtocol(user);
        }
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "viewProtocol");
    }

    private boolean canCreateProtocol(Person user) {
        ApplicationTask task = new ApplicationTask("createProtocol");
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), (Task)task);
    }

    private boolean canExecuteProtocolTask(String userId, ProtocolDocument doc, String taskName) {
        ProtocolTask task = new ProtocolTask(taskName, doc.getProtocol());
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, (Task)task);
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "modifyProtocol");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    public boolean canCancel(Document document, Person user) {
        return false;
    }

    public boolean canRoute(Document document, Person user) {
        return false;
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }

    public boolean canRecall(Document document, Person user) {
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "recallProtocol");
    }
}

