/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;

public class ReturnForSMRUnavailableAuthorizer
extends ProtocolAuthorizer {
    public boolean isAuthorized(String userId, ProtocolTask task) {
        ProtocolSubmission lastSubmission;
        ProtocolAction lastAction = task.getProtocol().getLastProtocolAction();
        return !this.canPerform(lastAction, lastSubmission = task.getProtocol().getProtocolSubmission()) && this.hasPermission(userId, (ProtocolBase)task.getProtocol(), "Maintain Protocol Submissions");
    }

    private boolean canPerform(ProtocolAction lastAction, ProtocolSubmission lastSubmission) {
        boolean canPerform = false;
        if (lastAction != null && lastSubmission != null) {
            boolean traditionalSubPerform = "308".equals(lastAction.getProtocolActionTypeCode()) && "3".equals(lastSubmission.getCommitteeDecisionMotionTypeCode());
            boolean exemptExpeditePerform = false;
            if (lastSubmission.getProtocolReviewType() != null) {
                exemptExpeditePerform = this.isExpeditedOrExempt(lastSubmission.getProtocolReviewType().getReviewTypeCode()) && "101".equals(lastAction.getProtocolActionTypeCode());
            }
            canPerform = traditionalSubPerform || exemptExpeditePerform;
        }
        return canPerform;
    }

    private boolean isExpeditedOrExempt(String reviewTypeCode) {
        return "3".equals(reviewTypeCode) || "2".equals(reviewTypeCode);
    }
}

