/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.noteattachment.AddProtocolAttachmentProtocolRuleImpl;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentFilter;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentVersioningUtility;
import org.kuali.kra.irb.noteattachment.ProtocolNotepad;
import org.kuali.kra.irb.noteattachment.ProtocolNotepadService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.NotesAttachmentsHelperBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentVersioningUtilityBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public class NotesAttachmentsHelper
extends NotesAttachmentsHelperBase {
    public NotesAttachmentsHelper(ProtocolForm form) {
        super((ProtocolFormBase)form, (org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)KraServiceLocator.getService(ProtocolAttachmentService.class), (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class), (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class), (DateTimeService)KraServiceLocator.getService(DateTimeService.class), (org.kuali.kra.protocol.noteattachment.ProtocolNotepadService)KraServiceLocator.getService(ProtocolNotepadService.class), (ParameterService)KraServiceLocator.getService(ParameterService.class), (ProtocolAttachmentVersioningUtilityBase)new ProtocolAttachmentVersioningUtility(form));
    }

    public boolean canEditProtocolAttachments() {
        ProtocolTask task = new ProtocolTask("modifyProtocolAttachments", (Protocol)this.getProtocol());
        return this.authService.isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public boolean canAddProtocolNotepads() {
        ProtocolTask task = new ProtocolTask("addProtocolNotes", (Protocol)this.getProtocol());
        return this.authService.isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public boolean canViewRestrictedProtocolNotepads() {
        ProtocolTask task = new ProtocolTask("viewRestrictedNotes", (Protocol)this.getProtocol());
        return this.authService.isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public boolean isProtocolAdmin() {
        return this.kraAuthorizationService.hasRole(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", "IRB Administrator");
    }

    public AddProtocolAttachmentProtocolRuleImpl getAddProtocolAttachmentProtocolRuleInstanceHook() {
        return new AddProtocolAttachmentProtocolRuleImpl();
    }

    protected ProtocolAttachmentProtocol createNewProtocolAttachmentProtocolInstanceHook(ProtocolBase protocol) {
        return new ProtocolAttachmentProtocol((Protocol)protocol);
    }

    protected ProtocolAttachmentPersonnel createNewProtocolAttachmentPersonnelInstanceHook(ProtocolBase protocol) {
        return new ProtocolAttachmentPersonnel((Protocol)protocol);
    }

    protected ProtocolAttachmentFilter createNewProtocolAttachmentFilterInstanceHook() {
        return new ProtocolAttachmentFilter();
    }

    protected String getAttachmentDefaultSortKeyHook() {
        return "protocolAttachmentDefaultSort";
    }

    public Class<ProtocolAttachmentProtocol> getProtocolAttachmentProtocolClassHook() {
        return ProtocolAttachmentProtocol.class;
    }

    public Class<ProtocolAttachmentPersonnel> getProtocolAttachmentPersonnelClassHook() {
        return ProtocolAttachmentPersonnel.class;
    }

    public Class<ProtocolNotepad> getProtocolNotepadClassHook() {
        return ProtocolNotepad.class;
    }

    public Class<ProtocolDocument> getProtocolDocumentClassHook() {
        return ProtocolDocument.class;
    }

    protected ProtocolNotepad createNewProtocolNotepadInstanceHook(ProtocolBase protocol) {
        return new ProtocolNotepad((Protocol)protocol);
    }
}

