/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.notification;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionQualifierType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.notification.IRBReplacementParameters;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRendererBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class IRBNotificationRenderer
extends ProtocolNotificationRendererBase {
    private static final long serialVersionUID = 7966684994606021231L;
    private Protocol protocol;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public IRBNotificationRenderer(Protocol protocol) {
        super((ProtocolBase)protocol);
        this.protocol = protocol;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = IRBReplacementParameters.REPLACEMENT_PARAMETERS;
        Map params = super.getDefaultReplacementParameters();
        String key = null;
        for (int i = 0; i < replacementParameters.length; ++i) {
            key = replacementParameters[i];
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_NUMBER}")) {
                params.put(key, this.protocol.getProtocolNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PI_NAME}")) {
                params.put(key, this.protocol.getPrincipalInvestigator().getFullName());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LEAD_UNIT}")) {
                params.put(key, this.protocol.getLeadUnitNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LEAD_UNIT_NAME}")) {
                params.put(key, this.protocol.getLeadUnitName());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_STATUS_CODE}")) {
                params.put(key, this.protocol.getProtocolStatusCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_STATUS_DESCRIPTION}")) {
                params.put(key, this.protocol.getProtocolStatus().getDescription());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_ACTION_NAME}")) {
                if (this.protocol.getLastProtocolAction() == null) continue;
                params.put(key, this.getProtocolLastActionName(this.protocol.getLastProtocolAction().getProtocolActionTypeCode()));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_ACTION_TYPE_CODE}")) {
                if (this.protocol.getLastProtocolAction() == null) continue;
                params.put(key, this.protocol.getLastProtocolAction().getProtocolActionTypeCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_NAME}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.getProtocolSubmissionName(this.protocol.getProtocolSubmission().getSubmissionTypeCode()));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_TYPE_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_TYPE_QUAL_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_TYPE_QUAL_NAME}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.getLastSubmissionTypeQualifierName(this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode()));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TITLE}")) {
                params.put(key, this.protocol.getTitle());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TYPE_CODE}")) {
                params.put(key, this.protocol.getProtocolTypeCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TYPE_DESCRIPTION}")) {
                if (this.protocol.getProtocolType() == null) continue;
                params.put(key, this.protocol.getProtocolType().getDescription());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.protocol.getSequenceNumber().toString());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SUBMISSION_STATUS_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionStatusCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SUBMISSION_STATUS_NAME}")) {
                params.put(key, this.protocol.getProtocolSubmissionStatus());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.protocol.getProtocolDocument().getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_REVIEW_TYPE_DESC}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.getSafeMessage(key, this.getProtocolReviewTypeDescription(this.protocol.getProtocolSubmission().getProtocolReviewTypeCode())));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_INITIAL_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() == null || this.protocol.getApprovalDate() == null) continue;
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getApprovalDate())));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_LAST_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() == null || this.protocol.getLastApprovalDate() == null) continue;
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getLastApprovalDate())));
                continue;
            }
            if (!StringUtils.equals((String)key, (String)"{PROTOCOL_EXPIRATION_DATE}") || this.protocol.getProtocolSubmission() == null || this.protocol.getExpirationDate() == null) continue;
            params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getExpirationDate())));
        }
        return params;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private String getProtocolLastActionName(String lastActionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolActionTypeCode", lastActionTypeCode);
        List actionTypes = (List)this.getBusinessObjectService().findMatching(ProtocolActionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)actionTypes)) {
            result = ((ProtocolActionType)actionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolSubmissionName(String submissionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("submissionTypeCode", submissionTypeCode);
        List submissionTypes = (List)this.getBusinessObjectService().findMatching(ProtocolSubmissionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionTypes)) {
            result = ((ProtocolSubmissionType)submissionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getLastSubmissionTypeQualifierName(String submissionQualifierTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("submissionQualifierTypeCode", submissionQualifierTypeCode);
        List submissionQualifierTypes = (List)this.getBusinessObjectService().findMatching(ProtocolSubmissionQualifierType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionQualifierTypes)) {
            result = ((ProtocolSubmissionQualifierType)submissionQualifierTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolReviewTypeDescription(String reviewTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("reviewTypeCode", reviewTypeCode);
        List protocolReviewTypes = (List)this.getBusinessObjectService().findMatching(ProtocolReviewType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)protocolReviewTypes)) {
            result = ((ProtocolReviewType)protocolReviewTypes.get(0)).getDescription();
        }
        return result;
    }

    protected Class<? extends CommitteeBase> getCommonCommitteeBOClassHook() {
        return Committee.class;
    }
}

