/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.onlinereview;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.actions.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.irb.actions.notification.DeleteReviewNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.notification.RejectReviewNotificationRenderer;
import org.kuali.kra.irb.actions.reviewcomments.ReviewAttachmentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.onlinereview.OnlineReviewsActionHelper;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.ProtocolReviewAttachment;
import org.kuali.kra.irb.onlinereview.event.AddProtocolOnlineReviewAttachmentEvent;
import org.kuali.kra.irb.onlinereview.event.DeleteProtocolOnlineReviewEvent;
import org.kuali.kra.irb.onlinereview.event.RejectProtocolOnlineReviewCommentEvent;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.onlinereview.event.AddProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.RouteProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.event.SaveProtocolOnlineReviewEvent;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.util.DateUtils;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProtocolOnlineReviewAction
extends ProtocolAction
implements AuditModeAction {
    private static final Log LOG = LogFactory.getLog(ProtocolOnlineReviewAction.class);
    private static final String PROTOCOL_TAB = "protocol";
    private static final String PROTOCOL_OLR_TAB = "onlineReview";
    private static final String DOCUMENT_REJECT_QUESTION = "DocReject";
    private static final String DOCUMENT_DELETE_QUESTION = "ProtocolDocDelete";
    private static final String UPDATE_REVIEW_STATUS_TO_FINAL = "statusToFinal";
    private static final String DOCUMENT_REJECT_REASON_MAXLENGTH = "2000";
    private static final String ERROR_DOCUMENT_DELETE_REASON_REQUIRED = "You must enter a reason for this deletion.  The reason must be no more than {0} characters long.";
    private static final String NOT_FOUND_SELECTION = "the attachment was not found for selection ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String PROTOCOL_DOCUMENT_NUMBER = "protocolDocumentNumber";
    private static final String PROTOCOL_ONLINE_REVIEW_DOCUMENT_NUMBER = "protocolOnlineReviewDocumentNumber";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ((ProtocolForm)form).getActionHelper().prepareView();
        ((ProtocolForm)form).getOnlineReviewsActionHelper().init(false);
        return actionForward;
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((ProtocolForm)form), true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((ProtocolForm)form), false);
    }

    public ActionForward refreshPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolForm)form).getOnlineReviewsActionHelper().init(false);
        return mapping.findForward("basic");
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    private boolean validateCreateNewProtocolOnlineReview(ProtocolForm protocolForm) {
        boolean valid = true;
        if (protocolForm.getOnlineReviewsActionHelper().getNewProtocolReviewCommitteeMembershipId() == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newProtocolReviewCommitteeMembershipId", "error.protocol.onlinereview.create.requiresReviewer", new String[0]);
        }
        if (protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested() != null && protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue() != null && !DateUtils.isSameDay((Date)protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue(), (Date)protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested()) && !protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue().after(protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newReviewDateDue", "error.protocol.onlinereview.create.dueDateAfterRequestedDate", new String[0]);
        }
        if (StringUtils.isEmpty((String)protocolForm.getOnlineReviewsActionHelper().getNewReviewerTypeCode())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newReviewerTypeCode", "error.protocol.onlinereview.create.protocolReviewerTypeCode", new String[0]);
        }
        return valid;
    }

    public ActionForward createOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper onlineReviewHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        if (this.validateCreateNewProtocolOnlineReview(protocolForm)) {
            CommitteeMembership membership = (CommitteeMembership)this.getBusinessObjectService().findBySinglePrimaryKey(CommitteeMembership.class, (Object)onlineReviewHelper.getNewProtocolReviewCommitteeMembershipId());
            ProtocolReviewerBean bean = new ProtocolReviewerBean(membership);
            String principalId = bean.getPersonId();
            boolean nonEmployeeFlag = bean.getNonEmployeeFlag();
            String reviewerTypeCode = onlineReviewHelper.getNewReviewerTypeCode();
            ProtocolSubmission submission = protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission();
            org.kuali.kra.irb.actions.submit.ProtocolReviewer reviewer = (org.kuali.kra.irb.actions.submit.ProtocolReviewer)this.getProtocolOnlineReviewService().createProtocolReviewer(principalId, nonEmployeeFlag, reviewerTypeCode, (ProtocolSubmissionBase)submission);
            ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)this.getProtocolOnlineReviewService().createAndRouteProtocolOnlineReviewDocument((ProtocolSubmissionBase)submission, (ProtocolReviewer)reviewer, onlineReviewHelper.getNewReviewDocumentDescription(), onlineReviewHelper.getNewReviewExplanation(), onlineReviewHelper.getNewReviewOrganizationDocumentNumber(), null, true, onlineReviewHelper.getNewReviewDateRequested(), onlineReviewHelper.getNewReviewDateDue(), GlobalVariables.getUserSession().getPrincipalId());
            protocolForm.getOnlineReviewsActionHelper().init(true);
            this.recordOnlineReviewActionSuccess("created", document);
            Protocol protocol = (Protocol)submission.getProtocol();
            ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)document.getProtocolOnlineReview();
            AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(protocol, "added");
            return this.checkToSendNotification(mapping, mapping.findForward("onlineReview"), protocolForm, (IRBNotificationRenderer)renderer, new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "901", "Assign Reviewer", null, null));
        }
        return mapping.findForward("basic");
    }

    protected String getOnlineReviewActionDocumentNumber(String parameterName, String actionMethodToCall) {
        String idxStr = null;
        if (StringUtils.isBlank((String)parameterName) || parameterName.indexOf("." + actionMethodToCall + ".") == -1) {
            throw new IllegalArgumentException(String.format("getOnlineReviewActionIndex expects a non-empty value for parameterName parameter, and it must contain as a substring the parameter actionMethodToCall. The passed values were (%s,%s).", parameterName, actionMethodToCall));
        }
        idxStr = StringUtils.substringBetween((String)parameterName, (String)("." + actionMethodToCall + "."), (String)".");
        if (idxStr == null || StringUtils.isBlank((String)idxStr)) {
            throw new IllegalArgumentException(String.format("parameterName must be of the form '.(actionMethodToCall).(index).anchor, the passed values were (%s,%s)", parameterName, actionMethodToCall));
        }
        return idxStr;
    }

    protected int getOnlineReviewActionIndexNumber(String parameterName, String actionMethodToCall) {
        int result = -1;
        if (StringUtils.isBlank((String)parameterName) || parameterName.indexOf("." + actionMethodToCall + ".") == -1) {
            throw new IllegalArgumentException(String.format("getOnlineReviewActionIndex expects a non-empty value for parameterName parameter, and it must contain as a substring the parameter actionMethodToCall. The passed values were (%s,%s).", parameterName, actionMethodToCall));
        }
        String idxNmbr = StringUtils.substringBetween((String)parameterName, (String)".line.", (String)".anchor");
        result = Integer.parseInt(idxNmbr);
        return result;
    }

    public ActionForward startProtocolOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap fieldValues = new HashMap();
        String protocolDocumentNumber = request.getParameter("protocolDocumentNumber");
        ((ProtocolForm)form).setDocument(this.getDocumentService().getByDocumentHeaderId(protocolDocumentNumber));
        ((ProtocolForm)form).initialize();
        return mapping.findForward("basic");
    }

    public ActionForward approveOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "approveOnlineReview");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)protocolForm.getOnlineReviewsActionHelper().getDocumentFromHelperMap(onlineReviewDocumentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        ReviewAttachmentsBean reviewAttachmentsBean = (ReviewAttachmentsBean)protocolForm.getOnlineReviewsActionHelper().getReviewAttachmentsBeanFromHelperMap(onlineReviewDocumentNumber);
        boolean isApproveReview = StringUtils.equals((String)"S", (String)prDoc.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode());
        boolean validComments = this.applyRules((KualiDocumentEvent)new RouteProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)));
        boolean statusIsOk = false;
        if (validComments && this.getKraWorkflowService().isUserApprovalRequested((Document)prDoc, GlobalVariables.getUserSession().getPrincipalId())) {
            prDoc.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("F");
            prDoc.getProtocolOnlineReview().setReviewerApproved(true);
            if (this.getKraWorkflowService().isDocumentOnNode((Document)prDoc, "IRBAdminReview")) {
                prDoc.getProtocolOnlineReview().setAdminAccepted(true);
                this.setOnlineReviewCommentFinalFlags((ProtocolOnlineReview)prDoc.getProtocolOnlineReview(), true);
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)prDoc.getProtocolOnlineReview());
            this.getDocumentService().saveDocument((Document)prDoc);
            statusIsOk = true;
        }
        if (validComments && statusIsOk) {
            this.getReviewCommentsService().saveReviewComments(reviewCommentsBean.getReviewComments(), reviewCommentsBean.getDeletedReviewComments());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachmentsBean.getReviewAttachments(), reviewAttachmentsBean.getDeletedReviewAttachments());
            prDoc.getProtocolOnlineReview().addActionPerformed("Approve");
            this.getDocumentService().saveDocument((Document)prDoc);
            this.getDocumentService().approveDocument((Document)prDoc, "", null);
            protocolForm.getOnlineReviewsActionHelper().init(true);
            this.recordOnlineReviewActionSuccess("approved", prDoc);
            Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
            ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)prDoc.getProtocolOnlineReview();
            IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
            ActionForward forward = null;
            if (!protocolForm.getEditingMode().containsKey("maintainProtocolOnlineReviews")) {
                forward = mapping.findForward("onlineReview");
            }
            return this.checkToSendNotificationWithHoldingPage(mapping, forward, protocolForm, renderer, new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "902", "Review Complete", prDoc.getDocumentNumber(), "Approve"));
        }
        return mapping.findForward("basic");
    }

    private ActionForward checkToSendNotificationWithHoldingPage(ActionMapping mapping, ActionForward forward, ProtocolForm protocolForm, IRBNotificationRenderer renderer, ProtocolNotificationRequestBean notificationRequestBean) {
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBean.getProtocol(), notificationRequestBean.getProtocolOnlineReview(), notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), (NotificationRenderer)renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
            if (forward == null) {
                context.setForwardName("holdingPage:" + notificationRequestBean.getDocNumber() + ":" + notificationRequestBean.getOlrEvent());
            } else {
                context.setForwardName(forward.getName());
            }
            protocolForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
            return mapping.findForward("protocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocolForm.getProtocolDocument().getProtocol());
        if (forward == null) {
            return this.routeProtocolOLRToHoldingPage(mapping, protocolForm, notificationRequestBean.getDocNumber(), notificationRequestBean.getOlrEvent());
        }
        return forward;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolForm protocolForm, IRBNotificationRenderer renderer, ProtocolNotificationRequestBean notificationRequestBean) {
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBean.getProtocol(), notificationRequestBean.getProtocolOnlineReview(), notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), (NotificationRenderer)renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
            context.setForwardName(forward.getName());
            protocolForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
            return mapping.findForward("protocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocolForm.getProtocolDocument().getProtocol());
        return forward;
    }

    private ActionForward routeProtocolOLRToHoldingPage(ActionMapping mapping, ProtocolForm protocolForm, String olrDocId, String olrEvent) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "onlineReview", "ProtocolDocument");
        returnLocation = returnLocation + "&olrDocId=" + olrDocId + "&" + "olrEvent=" + olrEvent;
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        GlobalVariables.getUserSession().addObject("holdingPageDocumentId", (Object)olrDocId);
        GlobalVariables.getUserSession().addObject("alternateDocIdSessionKey", (Object)"holdingPageDocumentId");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    public ActionForward blanketApproveOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "blanketApproveOnlineReview");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)((Map)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber)).get("document");
        prDoc.getProtocolOnlineReview().addActionPerformed("BlanketApprove");
        this.getDocumentService().blanketApproveDocument((Document)prDoc, "", null);
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward saveOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "saveOnlineReview");
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)protocolForm.getOnlineReviewsActionHelper().getDocumentFromHelperMap(onlineReviewDocumentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        ReviewAttachmentsBean reviewAttachmentsBean = (ReviewAttachmentsBean)protocolForm.getOnlineReviewsActionHelper().getReviewAttachmentsBeanFromHelperMap(onlineReviewDocumentNumber);
        if (this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)))) {
            org.kuali.kra.irb.actions.submit.ProtocolReviewer reviewer = (org.kuali.kra.irb.actions.submit.ProtocolReviewer)prDoc.getProtocolOnlineReview().getProtocolReviewer();
            this.getBusinessObjectService().save((PersistableBusinessObject)reviewer);
            this.getReviewCommentsService().saveReviewComments(reviewCommentsBean.getReviewComments(), reviewCommentsBean.getDeletedReviewComments());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachmentsBean.getReviewAttachments(), reviewAttachmentsBean.getDeletedReviewAttachments());
            documentService.saveDocument((Document)prDoc);
            this.recordOnlineReviewActionSuccess("saved", prDoc);
            protocolForm.getOnlineReviewsActionHelper().init(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward rejectOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "rejectOnlineReview");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)((Map)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber)).get("document");
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String reason = request.getParameter("reason");
        String callerString = String.format("rejectOnlineReview.%s.anchor%s", prDoc.getDocumentNumber(), 0);
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, "DocReject", "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "");
        }
        if (!"DocReject".equals(question) || !"1".equals(buttonClicked)) {
            if (!this.applyRules((KualiDocumentEvent)new RejectProtocolOnlineReviewCommentEvent(prDoc, reason, new Integer("2000").intValue()))) {
                if (reason == null) {
                    reason = "";
                }
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "DocReject", "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "", reason, "error.protocol.onlinereview.comment.rejected", "reason", "2000");
            }
            if (KRADUtils.containsSensitiveDataPatternMatch((String)reason)) {
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "DocReject", "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason");
            }
            prDoc.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("S");
            prDoc.getProtocolOnlineReview().addActionPerformed("Reject");
            prDoc.getProtocolOnlineReview().setReviewerApproved(false);
            prDoc.getProtocolOnlineReview().setAdminAccepted(false);
            this.setOnlineReviewCommentFinalFlags((ProtocolOnlineReview)prDoc.getProtocolOnlineReview(), false);
            this.getDocumentService().saveDocument((Document)prDoc);
            this.getProtocolOnlineReviewService().returnProtocolOnlineReviewDocumentToReviewer((ProtocolOnlineReviewDocumentBase)prDoc, reason, GlobalVariables.getUserSession().getPrincipalId());
            Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
            ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)prDoc.getProtocolOnlineReview();
            RejectReviewNotificationRenderer renderer = new RejectReviewNotificationRenderer(protocol, reason);
            protocolForm.getOnlineReviewsActionHelper().init(true);
            this.recordOnlineReviewActionSuccess("returned to reviewer", prDoc);
            return this.checkToSendNotificationWithHoldingPage(mapping, null, protocolForm, (IRBNotificationRenderer)renderer, new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "903", "Return to Reviewer", prDoc.getDocumentNumber(), "Reject"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int noteTextMaxLength;
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "deleteOnlineReview");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)((Map)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber)).get("document");
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        String question = request.getParameter("questionIndex");
        String reason = request.getParameter("reason");
        String deleteNoteText = "";
        String callerString = String.format("disapproveOnlineReview.%s.anchor%s", prDoc.getDocumentNumber(), 0);
        if (!this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)))) {
            return mapping.findForward("basic");
        }
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, "ProtocolDocDelete", "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("ProtocolDocDelete".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        String introNoteMessage = "Deletion reason - ";
        deleteNoteText = introNoteMessage + reason;
        if (!this.applyRules((KualiDocumentEvent)new DeleteProtocolOnlineReviewEvent(prDoc, reason, deleteNoteText, noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText").intValue()))) {
            int reasonLimit = noteTextMaxLength - introNoteMessage.length();
            if (reason == null) {
                reason = "";
            }
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "ProtocolDocDelete", "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "", reason, "You must enter a reason for this deletion.  The reason must be no more than {0} characters long.", "reason", new Integer(reasonLimit).toString());
        }
        if (KRADUtils.containsSensitiveDataPatternMatch((String)deleteNoteText)) {
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "ProtocolDocDelete", "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason");
        }
        ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)prDoc.getProtocolOnlineReview();
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        DeleteReviewNotificationRenderer renderer = new DeleteReviewNotificationRenderer(protocol, reason);
        prDoc.getProtocolOnlineReview().addActionPerformed("Delete");
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)((Map)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber)).get("kualiForm");
        this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)kualiDocumentFormBase.getDocument();
        document.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("X");
        document.getProtocolOnlineReview().setReviewerApproved(false);
        document.getProtocolOnlineReview().setAdminAccepted(false);
        this.getBusinessObjectService().save((PersistableBusinessObject)document.getProtocolOnlineReview());
        this.getDocumentService().disapproveDocument((Document)document, deleteNoteText);
        KNSGlobalVariables.getMessageList().add("message.route.disapproved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        protocolForm.getOnlineReviewsActionHelper().init(true);
        this.recordOnlineReviewActionSuccess("deleted", prDoc);
        return this.checkToSendNotification(mapping, mapping.findForward("onlineReview"), protocolForm, (IRBNotificationRenderer)renderer, new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "905", "Review Deleted", null, null));
    }

    public ActionForward cancelOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "cancelOnlineReview");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolOnlineReviewDocument prDoc = (ProtocolOnlineReviewDocument)((Map)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber)).get("document");
        String callerString = String.format("rejectOnlineReview.%s.anchor%s", prDoc.getDocumentNumber(), 0);
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", callerString, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (!"DocCancel".equals(question) || "1".equals(buttonClicked)) {
            // empty if block
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
        this.getDocumentService().cancelDocument((Document)prDoc, kualiDocumentFormBase.getAnnotation());
        protocolForm.getOnlineReviewsActionHelper().init(true);
        if (!protocolForm.getEditingMode().containsKey("maintainProtocolOnlineReviews")) {
            return super.returnToSender(request, mapping, (KualiDocumentFormBase)protocolForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "addOnlineReviewComment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        if (this.applyRules((KualiDocumentEvent)new AddProtocolOnlineReviewCommentEvent((ProtocolOnlineReviewDocumentBase)document, reviewCommentsBean.getNewReviewComment(), documentIndex)) && this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            CommitteeScheduleMinute newReviewComment = (CommitteeScheduleMinute)reviewCommentsBean.getNewReviewComment();
            List reviewComments = reviewCommentsBean.getReviewComments();
            List deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            if (protocolForm.getEditingMode().get("maintainProtocolOnlineReviews") == null) {
                newReviewComment.setPrivateCommentFlag(true);
                newReviewComment.setFinalFlag(false);
            }
            newReviewComment.setMinuteEntryTypeCode("6");
            this.getReviewCommentsService().addReviewComment((CommitteeScheduleMinuteBase)newReviewComment, reviewComments, document.getProtocolOnlineReview());
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
            reviewCommentsBean.setNewReviewComment((CommitteeScheduleMinuteBase)new CommitteeScheduleMinute("6"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "addOnlineReviewAttachment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewAttachmentsBean reviewAttachmentsBean = (ReviewAttachmentsBean)actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        if (this.applyRules((KualiDocumentEvent)new AddProtocolOnlineReviewAttachmentEvent(document, reviewAttachmentsBean.getErrorPropertyName() + "s[" + documentIndex + "].", (ProtocolReviewAttachment)reviewAttachmentsBean.getNewReviewAttachment()))) {
            ProtocolReviewAttachment newReviewAttachment = (ProtocolReviewAttachment)reviewAttachmentsBean.getNewReviewAttachment();
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            if (protocolForm.getEditingMode().get("maintainProtocolOnlineReviews") == null) {
                newReviewAttachment.setProtocolPersonCanView(false);
            }
            this.getReviewCommentsService().addReviewAttachment((ProtocolReviewAttachmentBase)newReviewAttachment, reviewAttachments, document.getProtocolOnlineReview().getProtocol());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachments, deletedReviewAttachments);
            this.getDocumentService().saveDocument((Document)document);
            reviewAttachmentsBean.setNewReviewAttachment((ProtocolReviewAttachmentBase)new ProtocolReviewAttachment());
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveUpOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "moveUpOnlineReviewComment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "moveUpOnlineReviewComment");
        if (this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
            List reviewComments = reviewCommentsBean.getReviewComments();
            List deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, (ProtocolBase)protocol, commentIndex);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward moveDownOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "moveDownOnlineReviewComment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "moveDownOnlineReviewComment");
        if (this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
            List reviewComments = reviewCommentsBean.getReviewComments();
            List deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, (ProtocolBase)protocol, commentIndex);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward deleteOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "deleteOnlineReviewComment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBean reviewCommentsBean = (ReviewCommentsBean)actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "deleteOnlineReviewComment");
        if (this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            List reviewComments = reviewCommentsBean.getReviewComments();
            List deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, commentIndex, deletedReviewComments);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward deleteOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "deleteOnlineReviewAttachment");
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewAttachmentsBean reviewCommentsBean = (ReviewAttachmentsBean)actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int attachmentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "deleteOnlineReviewAttachment");
        if (this.applyRules((KualiDocumentEvent)new SaveProtocolOnlineReviewEvent((ProtocolOnlineReviewDocumentBase)document, actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber).getReviewComments(), documentIndex))) {
            List reviewAttachments = document.getProtocolOnlineReview().getReviewAttachments();
            List deletedReviewAttachments = reviewCommentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, attachmentIndex, deletedReviewAttachments);
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachments, deletedReviewAttachments);
            actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber).setReviewAttachments(reviewAttachments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private ReviewCommentsService getReviewCommentsService() {
        return (ReviewCommentsService)KraServiceLocator.getService(ReviewCommentsService.class);
    }

    private KraWorkflowService getKraWorkflowService() {
        return (KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class);
    }

    private KcNotificationService getKcNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    protected void recordOnlineReviewActionSuccess(String onlineReviewActionName, ProtocolOnlineReviewDocument document) {
        String documentInfo = String.format("document number:%s, reviewer:%s", document.getDocumentNumber(), document.getProtocolOnlineReview().getProtocolReviewer().getFullName());
        KNSGlobalVariables.getMessageList().add("message.protocol.onlinereview.document.action.successfully.completed", new String[]{onlineReviewActionName, documentInfo});
    }

    private void setOnlineReviewCommentFinalFlags(ProtocolOnlineReview onlineReview, boolean flagValue) {
        List minutes = onlineReview.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinute minute : minutes) {
            minute.setFinalFlag(flagValue);
        }
    }

    public ActionForward viewOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        OnlineReviewsActionHelper actionHelper = (OnlineReviewsActionHelper)protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "viewOnlineReviewAttachment");
        ReviewAttachmentsBean reviewCommentsBean = (ReviewAttachmentsBean)actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        int attachmentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "viewOnlineReviewAttachment");
        ProtocolReviewAttachment attachment = (ProtocolReviewAttachment)reviewCommentsBean.getReviewAttachments().get(attachmentIndex);
        if (attachment == null) {
            LOG.info((Object)("the attachment was not found for selection " + attachmentIndex));
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolOnlineReviewAction.getValidHeaderString((String)file.getName()), ProtocolOnlineReviewAction.getValidHeaderString((String)file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }
}

