/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.onlinereview;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.onlinereview.authorization.ProtocolOnlineReviewTask;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewFormBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolOnlineReviewForm
extends ProtocolOnlineReviewFormBase {
    private static Log LOG = LogFactory.getLog(ProtocolOnlineReviewForm.class);
    private static final Map<String, String> ONLINE_REVIEW_APPROVE_BUTTON_MAP = new HashMap();
    private static final long serialVersionUID = -7633960906991275328L;

    protected String getDefaultDocumentTypeName() {
        return "ProtocolOnlineReviewDocument";
    }

    protected String getLockRegion() {
        return "PROTOCOL";
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        ProtocolOnlineReviewDocument doc = (ProtocolOnlineReviewDocument)this.getProtocolOnlineReviewDocument();
        String externalImageURL = "kra.externalizable.images.url";
        TaskAuthorizationService tas = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new ProtocolOnlineReviewTask("rejectProtocolOnlineReview", doc)) && doc.getDocumentHeader().getWorkflowDocument().isEnroute() && "F".equals(doc.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode())) {
            String resubmissionImage = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_return_to_reviewer.gif";
            this.addExtraButton("methodToCall.rejectOnlineReview", resubmissionImage, "Return to reviewer");
        }
        return this.extraButtons;
    }

    public boolean getAdminFieldsEditable() {
        return ((KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class)).hasPermission(GlobalVariables.getUserSession().getPrincipalId(), (Permissionable)this.getProtocolOnlineReviewDocument().getProtocolOnlineReview().getProtocol(), "Maintain Protocol Online Reviews");
    }

    protected Log getLogHook() {
        return LOG;
    }

    protected Map<String, String> getOnlineReviewApproveButtonMapHook() {
        return ONLINE_REVIEW_APPROVE_BUTTON_MAP;
    }

    public boolean getIrbAdminFieldsEditable() {
        return this.getAdminFieldsEditable();
    }

    static {
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IRBAdminInitialReview", "buttonsmall_send_review_request.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("IRBAdminReview", "buttonsmall_accept_review_comments.gif");
        ONLINE_REVIEW_APPROVE_BUTTON_MAP.put("OnlineReviewer", "buttonsmall_approve_this_review.gif");
    }
}

