/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.onlinereview;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewServiceImplBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class ProtocolOnlineReviewServiceImpl
extends ProtocolOnlineReviewServiceImplBase
implements ProtocolOnlineReviewService {
    private static final Log LOG = LogFactory.getLog(ProtocolOnlineReviewServiceImpl.class);
    private static final String PROTOCOL_ONLINE_REVIEW_DOCUMENT_TYPE = "ProtocolOnlineReviewDocument";

    public boolean isProtocolInStateToBeReviewed(ProtocolBase protocol) {
        boolean isReviewable = false;
        ProtocolSubmission submission = ((Protocol)protocol).getProtocolSubmission();
        if (submission != null) {
            try {
                isReviewable = StringUtils.isNotEmpty((String)submission.getScheduleId()) || "2".equals(submission.getProtocolReviewTypeCode());
                isReviewable &= StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"100") || StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101");
                ProtocolDocument protocolDocument = (ProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
                isReviewable &= this.getKraWorkflowService().isDocumentOnNode((Document)protocolDocument, "IRBReview");
            }
            catch (WorkflowException e) {
                String errorString = String.format("WorkflowException checking route node for creating new ProtocolOnlineReviewDocument for protocol %s", submission.getProtocolNumber());
                LOG.error((Object)errorString, (Throwable)e);
                throw new RuntimeException(errorString, e);
            }
        }
        return isReviewable;
    }

    protected void removeOnlineReviewDocument(ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument, ProtocolSubmissionBase submission, String annotation) {
        if (protocolOnlineReviewDocument != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Found protocolOnlineReviewDocument %s, removing it.", protocolOnlineReviewDocument.getDocumentNumber()));
            }
            this.cancelOnlineReviewDocument(protocolOnlineReviewDocument, submission, annotation);
            protocolOnlineReviewDocument.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("X");
            List reviewComments = protocolOnlineReviewDocument.getProtocolOnlineReview().getCommitteeScheduleMinutes();
            ArrayList deletedReviewComments = new ArrayList();
            this.getReviewerCommentsService().deleteAllReviewComments(reviewComments, deletedReviewComments);
            this.getReviewerCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            submission.getProtocolReviewers().remove(protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolReviewer());
            this.getBusinessObjectService().save((PersistableBusinessObject)protocolOnlineReviewDocument.getProtocolOnlineReview());
        }
    }

    protected ProtocolOnlineReviewDocumentBase getNewProtocolOnlineReviewDocumentInstanceHook() {
        return new ProtocolOnlineReviewDocument();
    }

    protected String getProtocolOLRSavedStatusCodeHook() {
        return "S";
    }

    protected String getProtocolOLRRemovedCancelledStatusCodeHook() {
        return "X";
    }

    protected String getProtocolOLRDocumentTypeHook() {
        return PROTOCOL_ONLINE_REVIEW_DOCUMENT_TYPE;
    }

    protected ProtocolReviewer createNewProtocolReviewerInstanceHook() {
        return new ProtocolReviewer();
    }

    protected Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewBOClassHook() {
        return ProtocolOnlineReview.class;
    }

    protected Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook() {
        return ProtocolSubmission.class;
    }
}

