/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.permission;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.permission.PermissionsHelperBase;

public class PermissionsHelper
extends PermissionsHelperBase {
    private static final long serialVersionUID = 7892561010219047907L;

    public PermissionsHelper(ProtocolForm form) {
        super((ProtocolFormBase)form, "KC-PROTOCOL");
        this.form = form;
    }

    protected void initExcludedRolesHook() {
        if (this.excludeRoles == null) {
            this.excludeRoles = new HashSet();
        }
        this.excludeRoles.add("IRB Online Reviewer");
        this.excludeRoles.add("Active Committee Member");
        this.excludeRoles.add("Active Committee Member On Scheduled Date");
        this.excludeRoles.add("ProtocolApprover");
        this.excludeRoles.add("Active Committee Member On Protocol");
    }

    protected void buildDisplayNameMap() {
        if (this.displayNameMap == null) {
            this.displayNameMap = new HashMap();
            this.displayNameMap.put("Protocol Aggregator", "Aggregator");
            this.displayNameMap.put("Protocol Viewer", "Viewer");
            this.displayNameMap.put("Protocol Unassigned", "unassigned");
        }
    }

    public boolean canModifyPermissions() {
        ProtocolTask task = new ProtocolTask("modifyProtocolRoles", (Protocol)this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((String)roleName, (String)"Protocol Aggregator") || StringUtils.equals((String)roleName, (String)"Protocol Viewer");
    }
}

