/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.print.ProtocolPrintingService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.personnel.AddProtocolAttachmentPersonnelEvent;
import org.kuali.kra.irb.personnel.AddProtocolPersonnelEvent;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.personnel.AddProtocolUnitEvent;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProtocolPersonnelAction
extends ProtocolAction {
    private static final Log LOG = LogFactory.getLog(ProtocolPersonnelAction.class);
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL = "confirmDeleteAttachmentPersonnel";
    private static final String CONFIRM_NO_DELETE = "";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private ProtocolAttachmentService protocolAttachmentService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.getProtocolPersonnelService().selectProtocolUnit(this.getProtocolPersons(form));
        ((ProtocolForm)form).getPersonnelHelper().prepareView();
        return actionForward;
    }

    public ActionForward addProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolPerson newProtocolPerson = (ProtocolPerson)protocolForm.getPersonnelHelper().getNewProtocolPerson();
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new AddProtocolPersonnelEvent("", protocolForm.getProtocolDocument(), newProtocolPerson));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPerson((ProtocolBase)protocol, (ProtocolPersonBase)newProtocolPerson);
            if (StringUtils.equals((String)newProtocolPerson.getProtocolPersonRoleId(), (String)"PI")) {
                protocolForm.getProtocolHelper().setPersonId(newProtocolPerson.getPersonId());
            }
            protocolForm.getPersonnelHelper().setNewProtocolPerson((ProtocolPersonBase)new ProtocolPerson());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        this.getProtocolPersonnelService().deleteProtocolPerson((ProtocolBase)protocolDocument.getProtocol());
        return mapping.findForward("basic");
    }

    public ActionForward clearProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getPersonnelHelper().setNewProtocolPerson((ProtocolPersonBase)new ProtocolPerson());
        return mapping.findForward("basic");
    }

    public ActionForward addPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolAttachmentPersonnel newAttachmentPersonnel = (ProtocolAttachmentPersonnel)protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().get(selectedPersonIndex);
        newAttachmentPersonnel.setPersonId(protocolPerson.getProtocolPersonId());
        newAttachmentPersonnel.setProtocolNumber(protocolPerson.getProtocolNumber());
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new AddProtocolAttachmentPersonnelEvent("", protocolForm.getProtocolDocument(), newAttachmentPersonnel, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonAttachment((ProtocolBase)protocolDocument.getProtocol(), (ProtocolAttachmentPersonnelBase)newAttachmentPersonnel, selectedPersonIndex);
            protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().set(selectedPersonIndex, new ProtocolAttachmentPersonnel());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentBase attachment = (ProtocolAttachmentBase)protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        return this.printAttachmentProtocol(mapping, protocolForm, response, attachment);
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, ProtocolForm form, HttpServletResponse response, ProtocolAttachmentBase attachment) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolPersonnelAction.getValidHeaderString((String)file.getName()), ProtocolPersonnelAction.getValidHeaderString((String)file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getProtocolAttachmentFile(ProtocolForm form, ProtocolAttachmentBase attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts((ProtocolBase)form.getProtocolDocument().getProtocol());
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                Integer attachmentDocumentId = attachment.getDocumentId();
                List protocolAttachmentList = form.getProtocolDocument().getProtocol().getAttachmentProtocols();
                if (protocolAttachmentList.size() > 0) {
                    for (ProtocolAttachmentProtocol personnelAttachment : protocolAttachmentList) {
                        if (!attachmentDocumentId.equals(personnelAttachment.getDocumentId()) || !"2".equals(personnelAttachment.getStatusCode())) continue;
                        if (this.getProtocolAttachmentService().isNewAttachmentVersion((ProtocolAttachmentProtocolBase)personnelAttachment)) {
                            attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                            continue;
                        }
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                        LOG.info((Object)("this attachment version is invalid " + attachmentDocumentId));
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward deletePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument protocolDocument = ((ProtocolForm)form).getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnel attachment = (ProtocolAttachmentPersonnel)protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmDeleteAttachmentPersonnel", "document.question.deleteAttachment.text", new String[]{attachment.getAttachmentDescription(), attachment.getFile().getName()});
        return this.confirm(confirm, "confirmDeleteAttachmentPersonnel", "");
    }

    public ActionForward confirmDeleteAttachmentPersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument protocolDocument = ((ProtocolForm)form).getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnel attachment = (ProtocolAttachmentPersonnel)protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        if (attachment.getFileId() != null && !this.getProtocolAttachmentService().isSharedFile((ProtocolAttachmentPersonnelBase)attachment)) {
            ((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().add(attachment.getFile());
        }
        protocolPerson.getAttachmentPersonnels().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolUnit newProtocolPersonUnit = (ProtocolUnit)protocolForm.getPersonnelHelper().getNewProtocolPersonUnits().get(selectedPersonIndex);
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new AddProtocolUnitEvent("", (ProtocolDocumentBase)protocolForm.getProtocolDocument(), (ProtocolUnitBase)newProtocolPersonUnit, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonUnit(protocolForm.getPersonnelHelper().getNewProtocolPersonUnits(), (ProtocolPersonBase)protocolPerson, selectedPersonIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().deleteProtocolPersonUnit((ProtocolBase)protocolDocument.getProtocol(), selectedPersonIndex, this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward updateProtocolPersonView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().switchInvestigatorCoInvestigatorRole(protocolDocument.getProtocol().getProtocolPersons());
        this.getProtocolPersonnelService().syncPersonRoleAndUnit(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        this.getProtocolPersonnelService().syncPersonRoleAndAffiliation(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        return mapping.findForward("basic");
    }

    private WatermarkService getWatermarkService() {
        return (WatermarkService)KraServiceLocator.getService(WatermarkService.class);
    }

    private ProtocolPrintingService getProtocolPrintingService() {
        return (ProtocolPrintingService)KraServiceLocator.getService(ProtocolPrintingService.class);
    }

    protected int getSelectedPersonIndex(HttpServletRequest request, ProtocolDocument document) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"protocolPersons[", (String)"]."));
        }
        return selectedPersonIndex;
    }

    private List<ProtocolPersonBase> getProtocolPersons(ActionForm form) {
        return ((ProtocolForm)form).getProtocolDocument().getProtocol().getProtocolPersons();
    }

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            KraAuthorizationService kraAuthService;
            String personComparator;
            String string = personComparator = protocolPerson.getPersonId() != null ? protocolPerson.getPersonId() : protocolPerson.getRolodexId().toString();
            if (protocolPerson.isPrincipalInvestigator() && !personComparator.equals(protocol.getPrincipalInvestigatorId())) {
                protocol.setPrincipalInvestigatorId(null);
                if (protocolPerson.getPersonId() != null) {
                    kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
                    kraAuthService.addRole(protocolPerson.getPersonId(), "Protocol Aggregator", (Permissionable)protocol);
                    kraAuthService.addRole(protocolPerson.getPersonId(), "ProtocolApprover", (Permissionable)protocol);
                    protocolForm.getPermissionsHelper().resetUserStates();
                }
            } else if (!protocolPerson.isPrincipalInvestigator() && !StringUtils.equals((String)protocolPerson.getPersonId(), (String)protocol.getPrincipalInvestigatorId()) && protocolPerson.getPersonId() != null) {
                kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
                kraAuthService.addRole(protocolPerson.getPersonId(), "Protocol Viewer", (Permissionable)protocol);
                protocolForm.getPermissionsHelper().resetUserStates();
            }
            if (!protocolPerson.isAffiliationTypeCodeChanged()) continue;
            protocolForm.getPermissionsHelper().resetUserStates();
        }
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("protocolNumber", protocol.getProtocolNumber());
        keyMap.put("sequenceNumber", protocol.getSequenceNumber());
        List attachments = (List)this.getBusinessObjectService().findMatching(ProtocolAttachmentPersonnel.class, keyMap);
        ArrayList<AttachmentFile> filesToDelete = new ArrayList<AttachmentFile>();
        ArrayList<Long> attachmentIds = new ArrayList<Long>();
        for (ProtocolAttachmentPersonnelBase attachment : protocol.getAttachmentPersonnels()) {
            if (attachment.getId() == null) continue;
            attachmentIds.add(attachment.getId());
        }
        for (ProtocolAttachmentPersonnelBase attachment : attachments) {
            if (attachmentIds.contains(attachment.getId()) || this.getProtocolAttachmentService().isSharedFile(attachment)) continue;
            filesToDelete.add(attachment.getFile());
        }
        protocolForm.getNotesAttachmentsHelper().setFilesToDelete(filesToDelete);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        if (this.protocolAttachmentService == null) {
            this.protocolAttachmentService = (ProtocolAttachmentService)KraServiceLocator.getService(ProtocolAttachmentService.class);
        }
        return this.protocolAttachmentService;
    }

    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        if (!((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete());
            ((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().clear();
        }
    }
}

