/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.personnel.ProtocolUnitEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolUnitEventBase
extends KraDocumentEventBase
implements ProtocolUnitEvent {
    private static final Log LOG = LogFactory.getLog(ProtocolUnitEventBase.class);
    private ProtocolUnit protocolUnit;
    private int personIndex;

    protected ProtocolUnitEventBase(String description, String errorPathPrefix, ProtocolDocument document, ProtocolUnit protocolUnit, int personIndex) {
        super(description, errorPathPrefix, (Document)document);
        this.setProtocolUnit(protocolUnit);
        this.personIndex = personIndex;
        this.logEvent();
    }

    public ProtocolUnit getProtocolUnit() {
        return this.protocolUnit;
    }

    public int getPersonIndex() {
        return this.personIndex;
    }

    private void setProtocolUnit(ProtocolUnit protocolUnit) {
        this.protocolUnit = (ProtocolUnit)ObjectUtils.deepCopy((Serializable)protocolUnit);
    }

    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getProtocolUnit() == null) {
            logMessage.append("null protocolUnit");
        } else {
            logMessage.append(this.getProtocolUnit().toString());
        }
        LOG.debug((Object)logMessage);
    }
}

