/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolDocumentRule;
import org.kuali.kra.irb.ProtocolEventBase;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.actions.notification.FundingSourceNotificationRenderer;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.protocol.funding.AddProtocolFundingSourceEvent;
import org.kuali.kra.irb.protocol.funding.LookupProtocolFundingSourceEvent;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceServiceImpl;
import org.kuali.kra.irb.protocol.funding.ProtocolProposalDevelopmentDocumentService;
import org.kuali.kra.irb.protocol.funding.SaveProtocolFundingSourceLinkEvent;
import org.kuali.kra.irb.protocol.location.AddProtocolLocationEvent;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.irb.protocol.participant.AddProtocolParticipantEvent;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipantService;
import org.kuali.kra.irb.protocol.reference.AddProtocolReferenceEvent;
import org.kuali.kra.irb.protocol.reference.ProtocolReference;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceBean;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceService;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceType;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBeanBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolProtocolAction
extends ProtocolAction {
    private static final String CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY = "confirmDeleteProtocolFundingSource";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((String)commandParam) && commandParam.equals("displayDocSearchView") && StringUtils.isNotBlank((String)request.getParameter("submissionId"))) {
            for (ProtocolSubmissionBase protocolSubmission : protocolForm.getProtocolDocument().getProtocol().getProtocolSubmissions()) {
                if (StringUtils.isNotBlank((String)request.getParameter("submissionId"))) {
                    protocolForm.getProtocolDocument().getProtocol().setNotifyIrbSubmissionId(Long.valueOf(Long.parseLong(request.getParameter("submissionId"))));
                }
                if (!request.getParameter("submissionId").equals(protocolSubmission.getSubmissionId().toString())) continue;
                protocolForm.getProtocolDocument().getProtocol().setProtocolSubmission(protocolSubmission);
                break;
            }
        }
        protocolForm.getProtocolHelper().prepareView();
        return actionForward;
    }

    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolform = (ProtocolForm)form;
        String command = request.getParameter("command");
        String docId = request.getParameter("docId");
        if (StringUtils.isNotEmpty((String)command) && command.equals("displayDocSearchView") && StringUtils.isNotEmpty((String)docId)) {
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docId);
            protocolform.setDocument(retrievedDocument);
        }
        return super.headerTab(mapping, form, request, response);
    }

    protected <T extends BusinessObject> void processMultipleLookupResults(ProtocolDocumentBase protocolDocument, Class<T> lookupResultsBOClass, Collection<T> selectedBOs) {
        if (lookupResultsBOClass.isAssignableFrom(ResearchArea.class)) {
            ProtocolResearchAreaService service = (ProtocolResearchAreaService)KraServiceLocator.getService(ProtocolResearchAreaService.class);
            service.addProtocolResearchArea(protocolDocument.getProtocol(), selectedBOs);
            new ProtocolDocumentRule().processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)((ProtocolDocument)protocolDocument));
        }
    }

    public ActionForward addProtocolParticipant(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolParticipant newProtocolParticipant = protocolForm.getProtocolHelper().getNewProtocolParticipant();
        List protocolParticipants = protocolForm.getProtocolDocument().getProtocol().getProtocolParticipants();
        if (this.applyRules((KualiDocumentEvent)new AddProtocolParticipantEvent(protocolForm.getProtocolDocument(), newProtocolParticipant, protocolParticipants))) {
            this.getProtocolParticipantService().addProtocolParticipant(protocolForm.getProtocolDocument().getProtocol(), newProtocolParticipant);
            protocolForm.getProtocolHelper().setNewProtocolParticipant(new ProtocolParticipant());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolParticipant(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolParticipants().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolReferenceBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolReferenceBean bean = protocolForm.getNewProtocolReferenceBean();
        if (this.applyRules((KualiDocumentEvent)new AddProtocolReferenceEvent("", protocolForm.getProtocolDocument(), bean))) {
            ProtocolReferenceType type = (ProtocolReferenceType)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolReferenceType.class, (Object)bean.getProtocolReferenceTypeCode());
            ProtocolReference ref = new ProtocolReference(bean, protocolForm.getProtocolDocument().getProtocol(), type);
            ProtocolReferenceService service = (ProtocolReferenceService)KraServiceLocator.getService(ProtocolReferenceService.class);
            service.addProtocolReference((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), (ProtocolReferenceBase)ref);
            protocolForm.setNewProtocolReferenceBean((ProtocolReferenceBeanBase)new ProtocolReferenceBean());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolReferences().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolResearchArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolResearchAreas().remove(this.getLineToDelete(request));
        new ProtocolDocumentRule().processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)protocolForm.getProtocolDocument());
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolLocation newProtocolLocation = (ProtocolLocation)protocolForm.getProtocolHelper().getNewProtocolLocation();
        if (this.applyRules((KualiDocumentEvent)new AddProtocolLocationEvent("", protocolForm.getProtocolDocument(), newProtocolLocation))) {
            this.getProtocolLocationService().addProtocolLocation((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), (ProtocolLocationBase)newProtocolLocation);
            protocolForm.getProtocolHelper().setNewProtocolLocation((ProtocolLocationBase)new ProtocolLocation());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolLocations().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward clearProtocolLocationAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        this.getProtocolLocationService().clearProtocolLocationAddress((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    private ProtocolParticipantService getProtocolParticipantService() {
        return (ProtocolParticipantService)KraServiceLocator.getService((String)"protocolParticipantTypeService");
    }

    private ProtocolLocationService getProtocolLocationService() {
        return (ProtocolLocationService)KraServiceLocator.getService((String)"protocolLocationService");
    }

    public ActionForward addProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)protocolForm.getProtocolHelper().getNewFundingSource();
        List protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
        AddProtocolFundingSourceEvent event = new AddProtocolFundingSourceEvent("", (Document)protocolDocument, fundingSource, protocolFundingSources);
        protocolForm.getProtocolHelper().syncFundingSources((ProtocolBase)protocolDocument.getProtocol());
        if (this.applyRules((KualiDocumentEvent)event)) {
            protocolDocument.getProtocol().getProtocolFundingSources().add(protocolForm.getProtocolHelper().getNewFundingSource());
            protocolForm.getProtocolHelper().setNewFundingSource((ProtocolFundingSourceBase)new ProtocolFundingSource());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY, "question.protocol.fundingSource.delete.confirmation", new String[0]), CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY, "");
    }

    public ActionForward confirmDeleteProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY.equals(question)) {
            ProtocolForm protocolForm = (ProtocolForm)form;
            ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
            ProtocolFundingSource protocolFundingSource = (ProtocolFundingSource)protocolDocument.getProtocol().getProtocolFundingSources().remove(this.getLineToDelete(request));
            protocolForm.getProtocolHelper().getDeletedProtocolFundingSources().add(protocolFundingSource);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String line = request.getParameter("line");
        int lineNumber = Integer.parseInt(line);
        ProtocolFundingSource protocolFundingSource = (ProtocolFundingSource)protocolForm.getProtocolDocument().getProtocol().getProtocolFundingSources().get(lineNumber);
        String viewFundingSourceUrl = this.getProtocolFundingSourceService().getViewProtocolFundingSourceUrl((ProtocolFundingSourceBase)protocolFundingSource, (ProtocolActionBase)this);
        if (StringUtils.isNotEmpty((String)viewFundingSourceUrl)) {
            return new ActionForward(viewFundingSourceUrl, true);
        }
        return mapping.findForward("basic");
    }

    public String buildForwardUrl(String routeHeaderId) {
        return super.buildForwardUrl(routeHeaderId);
    }

    public ActionForward performFundingSourceLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnAction = null;
        ProtocolForm protocolForm = (ProtocolForm)form;
        String fundingSourceTypeCode = protocolForm.getProtocolHelper().getNewFundingSource().getFundingSourceTypeCode();
        LookupProtocolFundingSourceEvent event = new LookupProtocolFundingSourceEvent("", ((ProtocolForm)form).getDocument(), fundingSourceTypeCode, ProtocolEventBase.ErrorType.HARDERROR);
        if (this.applyRules((KualiDocumentEvent)event)) {
            Map.Entry entry = this.getProtocolFundingSourceService().getLookupParameters(fundingSourceTypeCode);
            String boClassName = (String)entry.getKey();
            String fieldConversions = (String)entry.getValue();
            String fullParameter = (String)request.getAttribute("methodToCallAttribute");
            String updatedParameter = this.getProtocolFundingSourceService().updateLookupParameter(fullParameter, boClassName, fieldConversions);
            request.setAttribute("methodToCallAttribute", (Object)updatedParameter);
            returnAction = super.performLookup(mapping, form, request, response);
            protocolForm.getProtocolHelper().setEditProtocolFundingSourceName(false);
        } else {
            returnAction = mapping.findForward("basic");
        }
        return returnAction;
    }

    private ProtocolFundingSourceService getProtocolFundingSourceService() {
        return (ProtocolFundingSourceService)KraServiceLocator.getService(ProtocolFundingSourceService.class);
    }

    private ProtocolProposalDevelopmentDocumentService getProtocolProposalDevelopmentDocumentService() {
        return (ProtocolProposalDevelopmentDocumentService)KraServiceLocator.getService(ProtocolProposalDevelopmentDocumentService.class);
    }

    public ActionForward createProposalDevelopment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolProposalDevelopmentDocumentService service;
        ProposalDevelopmentDocument proposalDevelopmentDocument;
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        if (protocolForm.getProtocolHelper().isProtocolProposalDevelopmentLinkingEnabled() && (proposalDevelopmentDocument = (service = this.getProtocolProposalDevelopmentDocumentService()).createProposalDevelopmentDocument(protocolForm)) != null) {
            DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
            ProtocolFundingSourceServiceImpl protocolFundingSourceServiceImpl = (ProtocolFundingSourceServiceImpl)this.getProtocolFundingSourceService();
            ProtocolFundingSource proposalProtocolFundingSource = (ProtocolFundingSource)protocolFundingSourceServiceImpl.updateProtocolFundingSource("4", developmentProposal.getProposalNumber(), developmentProposal.getSponsorName());
            proposalProtocolFundingSource.setProtocol((ProtocolBase)protocolDocument.getProtocol());
            List protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
            AddProtocolFundingSourceEvent event = new AddProtocolFundingSourceEvent("", (Document)protocolDocument, proposalProtocolFundingSource, protocolFundingSources);
            if (this.applyRules((KualiDocumentEvent)event)) {
                protocolDocument.getProtocol().getProtocolFundingSources().add(proposalProtocolFundingSource);
            }
        }
        return mapping.findForward("basic");
    }

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        this.preSaveProtocol(form);
    }

    private void preSaveProtocol(ActionForm form) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        List protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
        List deletedProtocolFundingSources = protocolForm.getProtocolHelper().getDeletedProtocolFundingSources();
        protocolForm.getProtocolHelper().setNewProtocolFundingSources(protocolForm.getProtocolHelper().findNewFundingSources());
        this.setDeletedFundingSource(form);
        protocolForm.getProtocolHelper().prepareRequiredFieldsForSave();
        protocolForm.getProtocolHelper().createInitialProtocolAction();
        if (protocolDocument.getProtocol().isNew() && this.applyRules((KualiDocumentEvent)new SaveProtocolFundingSourceLinkEvent((Document)protocolDocument, protocolFundingSources, deletedProtocolFundingSources))) {
            protocolForm.getProtocolHelper().syncSpecialReviewsWithFundingSources();
        }
    }

    private void setDeletedFundingSource(ActionForm form) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.setDeletedProtocolFundingSources(new ArrayList());
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getProtocolHelper().getDeletedProtocolFundingSources()) {
            if (fundingSource.getProtocolFundingSourceId() == null) continue;
            protocolForm.getDeletedProtocolFundingSources().add(fundingSource);
        }
    }

    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.preSaveProtocol(form);
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            this.fundingSourceNotification(form);
        }
        return forward;
    }

    public ActionForward performProtocolAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.docHandler(mapping, form, request, response);
        return super.protocolActions(mapping, form, request, response);
    }

    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        this.fundingSourceNotification(form);
    }

    private void fundingSourceNotification(ActionForm form) {
        IRBNotificationContext context;
        FundingSourceNotificationRenderer renderer;
        String fundingType;
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getProtocolHelper().getNewProtocolFundingSources()) {
            fundingType = "'" + fundingSource.getFundingSourceType().getDescription() + "': " + fundingSource.getFundingSourceNumber();
            renderer = new FundingSourceNotificationRenderer(protocol, fundingType, "linked to");
            context = new IRBNotificationContext(protocol, "904", "Funding Source", (NotificationRenderer)renderer);
            this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
        }
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getDeletedProtocolFundingSources()) {
            if (fundingSource.getProtocolFundingSourceId() == null) continue;
            fundingType = "'" + fundingSource.getFundingSourceType().getDescription() + "': " + fundingSource.getFundingSourceNumber();
            renderer = new FundingSourceNotificationRenderer(protocol, fundingType, "removed from");
            context = new IRBNotificationContext(protocol, "904", "Funding Source", (NotificationRenderer)renderer);
            this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
        }
    }

    private KcNotificationService getKcNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }
}

