/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.personnel.ProtocolPersonnelServiceImpl;
import org.kuali.kra.irb.protocol.ProtocolNumberService;
import org.kuali.kra.irb.protocol.funding.ProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.specialreview.SpecialReviewHelper;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentProtocolDocumentServiceImpl
implements ProposalDevelopmentProtocolDocumentService {
    private DocumentService documentService;
    private SystemAuthorizationService systemAuthorizationService;
    private KraAuthorizationService kraAuthorizationService;
    private ProtocolNumberService protocolNumberService;
    private SequenceAccessorService sequenceAccessorService;

    public ProtocolDocument createProtocolDocument(ProposalDevelopmentForm proposalDevelopmentForm) throws Exception {
        ProtocolDocument protocolDocument = null;
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        if (this.isAuthorizedCreateProtocol(proposalDevelopmentForm.getSpecialReviewHelper())) {
            protocolDocument = (ProtocolDocument)this.documentService.getNewDocument(ProtocolDocument.class);
            this.populateDocumentOverview(developmentProposal, protocolDocument);
            this.populateRequiredFields(developmentProposal, protocolDocument);
            this.populateProtocolPerson_Investigator(developmentProposal, protocolDocument);
            this.populateProtocolFundingSource(developmentProposal, protocolDocument);
            this.documentService.saveDocument((Document)protocolDocument);
            this.initializeAuthorization(protocolDocument);
        }
        return protocolDocument;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setProtocolNumberService(ProtocolNumberService protocolNumberService) {
        this.protocolNumberService = protocolNumberService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void populateDocumentOverview(DevelopmentProposal developmentProposal, ProtocolDocument protocolDocument) {
        ProposalDevelopmentDocument proposalDocument = developmentProposal.getProposalDocument();
        DocumentHeader proposalDocumentHeader = proposalDocument.getDocumentHeader();
        DocumentHeader protocolDocumentHeader = protocolDocument.getDocumentHeader();
        protocolDocumentHeader.setDocumentDescription("IRB - " + proposalDocumentHeader.getDocumentDescription());
        protocolDocumentHeader.setExplanation("Document created from Proposal - " + proposalDocumentHeader.getDocumentNumber());
        protocolDocumentHeader.setOrganizationDocumentNumber(proposalDocumentHeader.getOrganizationDocumentNumber());
    }

    public void populateRequiredFields(DevelopmentProposal developmentProposal, ProtocolDocument protocolDocument) throws Exception {
        Protocol protocol = protocolDocument.getProtocol();
        protocol.setProtocolNumber(this.protocolNumberService.generateProtocolNumber());
        protocol.setSequenceNumber(Integer.valueOf(0));
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_PROTOCOL_ID");
        protocol.setProtocolId(nextProtocolId);
        protocol.setTitle(developmentProposal.getTitle());
        protocol.setLeadUnitNumber(developmentProposal.getOwnedByUnitNumber());
        protocol.setPrincipalInvestigatorId(developmentProposal.getPrincipalInvestigator().getPersonId());
        ProtocolAction protocolAction = new ProtocolAction(protocol, null, "100");
        protocolAction.setComments("Protocol created");
        protocol.getProtocolActions().add(protocolAction);
    }

    public void initializeAuthorization(ProtocolDocument protocolDocument) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addRole(userId, "Protocol Aggregator", (Permissionable)protocolDocument.getProtocol());
        this.kraAuthorizationService.addRole(userId, "ProtocolApprover", (Permissionable)protocolDocument.getProtocol());
        List roles = this.systemAuthorizationService.getRoles("KC-PROTOCOL");
        for (Role role : roles) {
            List persons = this.kraAuthorizationService.getPersonsInRole((Permissionable)protocolDocument.getProtocol(), role.getName());
            for (KcPerson person : persons) {
                if (StringUtils.equals((String)person.getPersonId(), (String)userId)) continue;
                this.kraAuthorizationService.addRole(person.getPersonId(), role.getName(), (Permissionable)protocolDocument.getProtocol());
            }
        }
    }

    public void populateProtocolPerson_Investigator(DevelopmentProposal developmentProposal, ProtocolDocument protocolDocument) {
        ProtocolPerson protocolPerson = new ProtocolPerson();
        Protocol protocol = protocolDocument.getProtocol();
        protocolPerson.setPersonId(protocol.getPrincipalInvestigatorId());
        protocolPerson.setPersonName(developmentProposal.getPrincipalInvestigatorName());
        protocolPerson.setProtocolPersonRoleId("PI");
        ProtocolPersonnelServiceImpl protocolPersonnelService = (ProtocolPersonnelServiceImpl)KraServiceLocator.getService(ProtocolPersonnelService.class);
        protocolPersonnelService.addProtocolPerson((ProtocolBase)protocol, (ProtocolPersonBase)protocolPerson);
    }

    public boolean isAuthorizedCreateProtocol(SpecialReviewHelper specialReviewHelper) {
        boolean canCreateProposal = specialReviewHelper.isCanCreateIrbProtocol();
        return canCreateProposal;
    }

    private ProtocolFundingSourceService getProtocolFundingSourceService() {
        return (ProtocolFundingSourceService)KraServiceLocator.getService(ProtocolFundingSourceService.class);
    }

    public void populateProtocolFundingSource(DevelopmentProposal developmentProposal, ProtocolDocument protocolDocument) {
        Protocol protocol = protocolDocument.getProtocol();
        List protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceServiceImpl protocolFundingSourceServiceImpl = (ProtocolFundingSourceServiceImpl)this.getProtocolFundingSourceService();
        ProtocolFundingSource protocolFundingSource = (ProtocolFundingSource)protocolFundingSourceServiceImpl.updateProtocolFundingSource("1", developmentProposal.getSponsorCode(), developmentProposal.getSponsorName());
        protocolFundingSource.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolFundingSources.add(protocolFundingSource);
    }
}

