/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.participant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.protocol.participant.ParticipantType;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class ParticipantTypeValuesFinder
extends KeyValuesBase {
    private static final long serialVersionUID = 6315943281880005921L;

    public List<KeyValue> getKeyValues() {
        ProtocolDocument doc = this.getDocument();
        KeyValuesService keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        Collection participantTypes = keyValuesService.findAll(ParticipantType.class);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        for (ParticipantType participantType : participantTypes) {
            if (this.hasParticipant(doc, participantType)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(participantType.getParticipantTypeCode(), participantType.getDescription()));
        }
        return keyValues;
    }

    private ProtocolDocument getDocument() {
        ProtocolDocument doc = null;
        ProtocolForm form = (ProtocolForm)KNSGlobalVariables.getKualiForm();
        if (form != null) {
            doc = form.getProtocolDocument();
        }
        return doc;
    }

    private boolean hasParticipant(ProtocolDocument doc, ParticipantType participantType) {
        if (doc != null) {
            List protocolParticipants = doc.getProtocol().getProtocolParticipants();
            for (ProtocolParticipant protocolParticipant : protocolParticipants) {
                if (!protocolParticipant.getParticipantTypeCode().equals(participantType.getParticipantTypeCode())) continue;
                return true;
            }
        }
        return false;
    }
}

