/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.BaseQuestionnaireAuditRule;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ProtocolQuestionnaireAuditRule
extends BaseQuestionnaireAuditRule<ProtocolDocument>
implements DocumentAuditRule {
    private static final String PROTOCOL_QUESTIONNAIRE_KEY = "questionnaireHelper.answerHeaders[%s].answers[0].answer";
    private static final String PROTOCOL_QUESTIONNAIRE_PANEL_KEY = "%s%s%s";
    private boolean requestSubmission;

    public boolean processRunAuditBusinessRules(Document document) {
        Protocol protocol = ((ProtocolDocument)document).getProtocol();
        boolean isValid = true;
        ProtocolModuleQuestionnaireBean pmqb = new ProtocolModuleQuestionnaireBean(protocol);
        List headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)pmqb);
        if (headers != null) {
            for (int i = 0; i < headers.size(); ++i) {
                AnswerHeader header = (AnswerHeader)headers.get(i);
                QuestionnaireUsage usage = header.getQuestionnaire().getHighestVersionUsageFor(pmqb.getModuleItemCode(), pmqb.getModuleSubItemCode());
                if (usage != null && usage.isMandatory() && !header.getCompleted() && header.isActiveQuestionnaire()) {
                    isValid = false;
                    this.addMandatoryQuestionnaireErrorToAuditErrors(Integer.valueOf(i), usage);
                }
                if (!header.isNewerVersionPublished() || !header.isActiveQuestionnaire()) continue;
                isValid = false;
                this.addQuestionnaireNotUpdatedErrorToAuditErrors(Integer.valueOf(i), usage);
            }
        }
        if (!protocol.isNew() && protocol.getProtocolAmendRenewal().hasModule("026")) {
            pmqb = new ProtocolModuleQuestionnaireBean("7", protocol.getProtocolNumber(), "0", protocol.getSequenceNumber().toString(), protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().isApproved());
            List defAmendHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)pmqb);
            for (int i = 0; i < defAmendHeaders.size(); ++i) {
                AnswerHeader header = (AnswerHeader)defAmendHeaders.get(i);
                QuestionnaireUsage usage = header.getQuestionnaire().getHighestVersionUsageFor("7", "0");
                if (usage != null && usage.isMandatory() && !header.getCompleted() && header.isActiveQuestionnaire()) {
                    isValid = false;
                    this.addMandatoryQuestionnaireErrorToAuditErrors(Integer.valueOf(i + headers.size()), usage);
                }
                if (!header.isNewerVersionPublished() || !header.isActiveQuestionnaire()) continue;
                isValid = false;
                this.addQuestionnaireNotUpdatedErrorToAuditErrors(Integer.valueOf(i + headers.size()), usage);
            }
        }
        return isValid;
    }

    protected List<Integer> getIncompleteMandatoryQuestionnaire(ProtocolDocument protocolDocument) {
        Protocol protocol = protocolDocument.getProtocol();
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean(protocol);
        if (this.isRequestSubmission()) {
            moduleQuestionnaireBean.setModuleSubItemCode("2");
        }
        return super.getIncompleteMandatoryQuestionnaire("7", (ModuleQuestionnaireBean)moduleQuestionnaireBean);
    }

    protected void addQuestionnaireNotUpdatedErrorToAuditErrors(Integer answerHeaderIndex, QuestionnaireUsage usage) {
        String errorKey = String.format(PROTOCOL_QUESTIONNAIRE_KEY, answerHeaderIndex);
        String messageKey = "error.questionnaire.notUpdated";
        this.getProtocolAuditErrors("questionnaireHelper", usage.getQuestionnaireLabel(), answerHeaderIndex).add(new AuditError(errorKey, messageKey, this.getAuditErrorLink()));
    }

    private QuestionnaireUsage getQuestionnaireUsage(String moduleItemCode, List<QuestionnaireUsage> questionnaireUsages) {
        QuestionnaireUsage usage = null;
        int version = 0;
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (usage != null && (!moduleItemCode.equals(questionnaireUsage.getModuleItemCode()) || questionnaireUsage.getQuestionnaireSequenceNumber() <= version)) continue;
            version = questionnaireUsage.getQuestionnaireSequenceNumber();
            usage = questionnaireUsage;
        }
        return usage;
    }

    protected void addMandatoryQuestionnaireErrorToAuditErrors(Integer answerHeaderIndex, QuestionnaireUsage usage) {
        String errorKey = String.format(PROTOCOL_QUESTIONNAIRE_KEY, answerHeaderIndex);
        String messageKey = "error.mandatory.questionnaire";
        this.addErrorToAuditErrors(answerHeaderIndex, usage, errorKey, messageKey);
    }

    protected void addErrorToAuditErrors(Integer answerHeaderIndex, QuestionnaireUsage usage, String errorKey, String messageKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("questionnaire");
        stringBuilder.append(".");
        stringBuilder.append("Questionnaire");
        this.getProtocolAuditErrors("questionnaireHelper", usage.getQuestionnaireLabel(), answerHeaderIndex).add(new AuditError(errorKey, messageKey, stringBuilder.toString()));
    }

    private List<AuditError> getProtocolAuditErrors(String formProperty, String usageLabel, Integer answerHeaderIndex) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = String.format(PROTOCOL_QUESTIONNAIRE_PANEL_KEY, formProperty, usageLabel, answerHeaderIndex);
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster(usageLabel, auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }

    public boolean isMandatorySubmissionQuestionnaireComplete(List<AnswerHeader> answerHeaders) {
        boolean isValid = true;
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!this.getQuestionnaireUsage("7", "2", answerHeader.getQuestionnaire().getQuestionnaireUsages()).isMandatory() || this.getQuestionnaireAnswerService().isQuestionnaireAnswerComplete(answerHeader.getAnswers())) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    protected String getAuditErrorLink() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("questionnaire");
        stringBuilder.append(".");
        stringBuilder.append("Questionnaire");
        return stringBuilder.toString();
    }

    protected String getAuditErrorsLabel() {
        return null;
    }

    public boolean isRequestSubmission() {
        return this.requestSubmission;
    }

    public void setRequestSubmittion(boolean requestSubmission) {
        this.requestSubmission = requestSubmission;
    }
}

