/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.jqueryajax;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.common.notification.service.NotificationRoleSubQualifierFinders;
import org.kuali.kra.iacuc.IacucLocationName;
import org.kuali.kra.iacuc.actions.IacucProtocolActionAjaxService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.jqueryajax.JqueryAjaxForm;
import org.kuali.kra.protocol.actions.ProtocolActionAjaxService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class JqueryAjaxAction
extends KualiDocumentActionBase {
    protected NotificationRoleSubQualifierFinders notificationRoleSubQualifierFinders;
    private CoiDisclosureService coiDisclosureService;

    public ActionForward getUnitName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        Unit unit = this.getUnitService().getUnitCaseInsensitive(ajaxForm.getCode());
        String unitName = null;
        if (null != unit) {
            unitName = unit.getUnitName();
            if (null != unit.getUnitNumber()) {
                ajaxForm.setCode(unit.getUnitNumber());
            }
        }
        if (unitName == null && StringUtils.isNotBlank((String)ajaxForm.getCode())) {
            unitName = "<span style='color: red;'>not found</span>";
        }
        ajaxForm.setReturnVal(unitName);
        return mapping.findForward("basic");
    }

    public ActionForward getCoiDispositionStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        String disclosureStatusCode = ajaxForm.getCode();
        List coiDispositionStatuses = this.getCoiDisclosureService().getDispositionStatuses(disclosureStatusCode);
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ ");
        int index = 0;
        for (CoiDispositionStatus value : coiDispositionStatuses) {
            if (index > 0) {
                buffer.append(" , ");
            }
            buffer.append("{ 'key' :'");
            buffer.append(value.getCoiDispositionCode());
            buffer.append("', 'value' : '");
            buffer.append(value.getDescription());
            buffer.append("'}");
            ++index;
        }
        buffer.append("]");
        ajaxForm.setReturnVal(buffer.toString());
        return mapping.findForward("basic");
    }

    public ActionForward getIacucProcedureLocationNames(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        String locationTypeCode = ajaxForm.getCode();
        HashMap<String, String> filterValues = new HashMap<String, String>();
        filterValues.put("locationTypeCode", locationTypeCode);
        List iacucLocationNames = (List)this.getBusinessObjectService().findMatching(IacucLocationName.class, filterValues);
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ ");
        for (IacucLocationName value : iacucLocationNames) {
            buffer.append("{ 'key' :'");
            buffer.append(value.getLocationId());
            buffer.append("', 'value' : '");
            buffer.append(value.getLocationName());
            buffer.append("'} , ");
        }
        buffer.append("]");
        ajaxForm.setReturnVal(buffer.toString());
        return mapping.findForward("basic");
    }

    public ActionForward getProtocolReviewTypes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        String committeeTypeCode = ajaxForm.getCode();
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.equalsIgnoreCase((String)committeeTypeCode, (String)"1")) {
            List reviewTypes = (List)this.getBusinessObjectService().findAll(ProtocolReviewType.class);
            buffer.append("[ ");
            for (ProtocolReviewType reviewType : reviewTypes) {
                buffer.append("{ 'key' :'");
                buffer.append(reviewType.getReviewTypeCode());
                buffer.append("', 'value' : '");
                buffer.append(reviewType.getDescription());
                buffer.append("'} , ");
            }
            buffer.append("]");
        } else if (StringUtils.equalsIgnoreCase((String)committeeTypeCode, (String)"3")) {
            List reviewTypes = (List)this.getBusinessObjectService().findAll(IacucProtocolReviewType.class);
            buffer.append("[ ");
            for (IacucProtocolReviewType reviewType : reviewTypes) {
                buffer.append("{ 'key' :'");
                buffer.append(reviewType.getReviewTypeCode());
                buffer.append("', 'value' : '");
                buffer.append(reviewType.getDescription());
                buffer.append("'} , ");
            }
            buffer.append("]");
        }
        ajaxForm.setReturnVal(buffer.toString());
        return mapping.findForward("basic");
    }

    private UnitService getUnitService() {
        return (UnitService)KraServiceLocator.getService(UnitService.class);
    }

    public ActionForward getProtocolReviewers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String committeeId = request.getParameter("committeeId");
        String scheduleId = request.getParameter("scheduleId");
        String protocolId = request.getParameter("protocolId");
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        String reviewers = this.getProtocolAjaxService().getReviewers(protocolId, committeeId, scheduleId);
        ajaxForm.setReturnVal(reviewers.toString());
        return mapping.findForward("basic");
    }

    public ActionForward getProtocolReviewerTypes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        String types = this.getProtocolAjaxService().getReviewerTypes();
        ajaxForm.setReturnVal(types);
        return mapping.findForward("basic");
    }

    protected String clipLastChar(StringBuffer ajaxList) {
        if (ajaxList.length() == 0) {
            return ajaxList.toString();
        }
        return ajaxList.substring(0, ajaxList.length() - 1);
    }

    public ProtocolActionAjaxService getProtocolAjaxService() {
        return (ProtocolActionAjaxService)KraServiceLocator.getService(IacucProtocolActionAjaxService.class);
    }

    public ActionForward getSponsorTemplateDescription(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        AwardTemplate template = (AwardTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(AwardTemplate.class, (Object)ajaxForm.getCode());
        if (template != null) {
            ajaxForm.setReturnVal(template.getDescription());
        } else {
            ajaxForm.setReturnVal("<span style='color: red;'>not found</span>");
        }
        return mapping.findForward("basic");
    }

    public ActionForward getNotificationRoleSubQualifiers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JqueryAjaxForm ajaxForm = (JqueryAjaxForm)form;
        List values = this.getNotificationRoleSubQualifierFinders().getKeyValuesForRole(ajaxForm.getCode());
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ ");
        for (KeyValue value : values) {
            buffer.append("{ 'key' :'");
            buffer.append(value.getKey());
            buffer.append("', 'value' : '");
            buffer.append(value.getValue());
            buffer.append("'} , ");
        }
        buffer.append("]");
        ajaxForm.setReturnVal(buffer.toString());
        return mapping.findForward("basic");
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected CoiDisclosureService getCoiDisclosureService() {
        if (this.coiDisclosureService == null) {
            this.coiDisclosureService = (CoiDisclosureService)KraServiceLocator.getService(CoiDisclosureService.class);
        }
        return this.coiDisclosureService;
    }

    protected NotificationRoleSubQualifierFinders getNotificationRoleSubQualifierFinders() {
        if (this.notificationRoleSubQualifierFinders == null) {
            this.notificationRoleSubQualifierFinders = (NotificationRoleSubQualifierFinders)KraServiceLocator.getService(NotificationRoleSubQualifierFinders.class);
        }
        return this.notificationRoleSubQualifierFinders;
    }

    public void setNotificationRoleSubQualifierFinders(NotificationRoleSubQualifierFinders notificationRoleSubQualifierFinders) {
        this.notificationRoleSubQualifierFinders = notificationRoleSubQualifierFinders;
    }
}

