/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kew;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public class KraDocumentRejectionServiceImpl
implements KraDocumentRejectionService {
    private static final Log LOG = LogFactory.getLog(KraDocumentRejectionServiceImpl.class);
    private DocumentService documentService;
    private WorkflowDocumentService workflowDocumentService;

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public String getWorkflowInitialNodeName(String documentType) {
        DocumentTypeService documentTypeService = KEWServiceLocator.getDocumentTypeService();
        DocumentType proposalDevDocType = documentTypeService.findByName(documentType);
        return proposalDevDocType.getPrimaryProcess().getInitialRouteNode().getRouteNodeName();
    }

    public void reject(String documentNumber, String reason, String principalId, String appDocStatus) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Rejecting document:%s as %s with reason '%s'", documentNumber, principalId, reason));
            }
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)documentNumber);
            workflowDocument.returnToPreviousNode(reason, this.getWorkflowInitialNodeName(workflowDocument.getDocumentTypeName()));
            if (appDocStatus != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Setting application document status of document %s to %s", documentNumber, appDocStatus));
                }
                workflowDocument.setApplicationDocumentStatus(appDocStatus);
            }
        }
        catch (Exception we) {
            LOG.error((Object)String.format("Exception generated when trying to return document %s to initial route node.  Reason:%s", documentNumber, we.getMessage()));
            throw new RuntimeException(String.format("Exception generated when trying to return document %s to initial route node.  Reason:%s", documentNumber, we.getMessage()), we);
        }
    }

    public void reject(String documentNumber, String reason, String principalId) {
        this.reject(documentNumber, reason, principalId, null);
    }

    public void reject(Document document, String reason, String principalId, String appDocStatus) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Rejecting document:%s as %s with reason '%s'", document.getDocumentNumber(), principalId, reason));
            }
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentHeader().getWorkflowDocument().getDocumentId());
            workflowDocument.returnToPreviousNode(reason, this.getWorkflowInitialNodeName(workflowDocument.getDocumentTypeName()));
            if (appDocStatus != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Setting application document status of document %s to %s", document.getDocumentNumber(), appDocStatus));
            }
        }
        catch (Exception we) {
            LOG.error((Object)String.format("Exception generated when trying to return document %s to initial route node.  Reason:%s", document.getDocumentNumber(), we.getMessage()));
            throw new RuntimeException(String.format("Exception generated when trying to return document %s to initial route node.  Reason:%s", document.getDocumentNumber(), we.getMessage()), we);
        }
    }

    public void reject(Document document, String reason, String principalId) {
        this.reject(document, reason, principalId, null);
    }

    public boolean isDocumentOnInitialNode(Document document) {
        boolean ret = false;
        if (document != null) {
            ret = this.isDocumentOnNode(document, this.getWorkflowInitialNodeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()));
        }
        return ret;
    }

    public boolean isDocumentOnInitialNode(String documentNumber) {
        try {
            Document document = this.documentService.getByDocumentHeaderId(documentNumber);
            return this.isDocumentOnInitialNode(document);
        }
        catch (WorkflowException we) {
            LOG.error((Object)String.format("WorkflowException generated when trying to return document %s to initial route node.  Reason:%s", documentNumber, we.getMessage()));
            throw new RuntimeException(String.format("WorkflowException generated when trying to return document %s to initial route node.  Reason:%s", documentNumber, we.getMessage()), we);
        }
    }

    public boolean isDocumentOnNode(Document document, String nodeName) {
        if (document != null && StringUtils.isNotEmpty((String)nodeName)) {
            String currentRouteNodeNames = this.workflowDocumentService.getCurrentRouteNodeNames(document.getDocumentHeader().getWorkflowDocument());
            return StringUtils.contains((String)currentRouteNodeNames, (String)nodeName);
        }
        return false;
    }

    public boolean isDocumentOnNode(String documentNumber, String nodeName) {
        try {
            Document document = this.documentService.getByDocumentHeaderId(documentNumber);
            return this.isDocumentOnNode(document, nodeName);
        }
        catch (WorkflowException we) {
            LOG.error((Object)String.format("WorkflowException generated when trying to determine if document %s is on %s node.  Reason:%s", nodeName, documentNumber, we.getMessage()));
            throw new RuntimeException(String.format("WorkflowException generated when trying determine if document %s is on %s route node.  Reason:%s", nodeName, documentNumber, we.getMessage()), we);
        }
    }

    public void reject(Document document, String reason, String principalId, String appDocStatus, String nodeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Rejecting document %s to node %s as %s with reason '%s'", document.getDocumentNumber(), nodeName, principalId, reason));
        }
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentHeader().getWorkflowDocument().getDocumentId());
        workflowDocument.returnToPreviousNode(reason, nodeName);
        if (appDocStatus != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Setting application document status of document %s to %s", document.getDocumentNumber(), appDocStatus));
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

