/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kew;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SplitResult;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class SimpleBooleanSplitNode
implements SplitNode {
    private static Log LOG = LogFactory.getLog(SimpleBooleanSplitNode.class);

    public SplitResult process(RouteContext context, RouteHelper helper) throws Exception {
        Document document;
        String documentID = context.getDocument().getDocumentId().toString();
        String routeNodeName = context.getNodeInstance().getRouteNode().getRouteNodeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Entering routeNode:%s for documentId:%s", routeNodeName, documentID));
        }
        if ((document = ((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderIdSessionless(documentID)) instanceof ResearchDocumentBase) {
            boolean ret = ((ResearchDocumentBase)document).answerSplitNodeQuestion(routeNodeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("answerSplitNodeQuestion returned:%s", ret));
            }
            return this.booleanToSplitResult(ret);
        }
        throw new UnsupportedOperationException("Document was not instance of:" + ResearchDocumentBase.class + ", not supported by SimpleBooleanSplitNode.");
    }

    protected SplitResult booleanToSplitResult(boolean b) {
        ArrayList<String> branches = new ArrayList<String>();
        String branchName = b ? "True" : "False";
        branches.add(branchName);
        return new SplitResult(branches);
    }
}

