/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.OrganizationCorrespondent;
import org.kuali.kra.bo.UnitCorrespondent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.kra.service.OrganizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class IrbCorrespondentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private OrganizationService organizationService;
    private UnitService unitService;
    private final String ROLE_NAME_ORGANIZATION_CORRESPONDENT = "Organization Correspondent";
    private final String ROLE_NAME_UNIT_CORRESPONDENT = "Unit Correspondent";
    protected List<String> requiredAttributes = new ArrayList();

    public IrbCorrespondentDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if ("Organization Correspondent".equals(roleName)) {
            return this.hasApplicationRoleOrganization(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        if ("Unit Correspondent".equals(roleName)) {
            return this.hasApplicationRoleUnit(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        return false;
    }

    public boolean hasApplicationRoleOrganization(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocolByNumber(protocolNumber);
        String organizationId = protocol.getPerformingOrganizationId();
        if (StringUtils.isNotBlank((String)organizationId)) {
            List organizationCorrespondents = this.getOrganizationService().retrieveOrganizationCorrespondentsByOrganizationId(organizationId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!organizationCorrespondent.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasApplicationRoleUnit(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocolByNumber(protocolNumber);
        String unitNumber = protocol.getLeadUnitNumber();
        if (StringUtils.isNotBlank((String)unitNumber)) {
            List unitCorrespondents = this.getUnitService().retrieveUnitCorrespondentsByUnitNumber(unitNumber);
            for (UnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!unitCorrespondent.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        if (protocolNumber != null) {
            Protocol protocol = this.getProtocolByNumber(protocolNumber);
            if ("Organization Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleOrganization(protocol, namespaceCode, roleName, qualification);
            }
            if ("Unit Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleUnit(protocol, namespaceCode, roleName, qualification);
            }
        }
        return new ArrayList<RoleMembership>();
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleOrganization(Protocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        ProtocolSummary protocolSummary = protocol.getProtocolSummary();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        for (OrganizationSummary orgSummary : protocolSummary.getOrganizations()) {
            String organizationId = orgSummary.getId();
            if (!StringUtils.isNotBlank((String)organizationId)) continue;
            List organizationCorrespondents = this.getOrganizationService().retrieveOrganizationCorrespondentsByOrganizationId(organizationId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!StringUtils.isNotBlank((String)organizationCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)organizationCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleUnit(Protocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        String unitNumber = protocol.getLeadUnitNumber();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((String)unitNumber)) {
            List unitCorrespondents = this.getUnitService().retrieveUnitCorrespondentsByUnitNumber(unitNumber);
            for (UnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!StringUtils.isNotBlank((String)unitCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)unitCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    private UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = (UnitService)KraServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)KraServiceLocator.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private Protocol getProtocolByNumber(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        return (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, keymap);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

