/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimAttributeFieldContract;
import org.kuali.rice.kns.kim.role.RoleTypeServiceBase;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class UnitHierarchyRoleTypeServiceImpl
extends RoleTypeServiceBase {
    private UnitService unitService;

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (this.roleQualifiedByUnitHierarchy(roleQualifier) && qualification.containsKey("unitNumber")) {
            return this.performWildCardMatching(qualification, roleQualifier) || this.unitQualifierMatches(qualification, roleQualifier) || this.unitQualifierMatchesHierarchy(qualification, roleQualifier);
        }
        return false;
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        List<Object> validationErrors = new ArrayList<RemotableAttributeError>();
        if (this.roleQualifiedByUnitHierarchy(attributes) && attributes.containsKey("unitNumber")) {
            validationErrors = super.validateAttributes(kimTypeId, attributes);
        }
        return validationErrors;
    }

    protected boolean roleQualifiedByUnitHierarchy(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("unitNumber") && roleQualifier.containsKey("subunits");
    }

    protected boolean unitQualifierMatches(Map<String, String> qualification, Map<String, String> roleQualifier) {
        return StringUtils.equals((String)qualification.get("unitNumber"), (String)roleQualifier.get("unitNumber"));
    }

    protected boolean unitQualifierMatchesHierarchy(Map<String, String> qualification, Map<String, String> roleQualifier) {
        String parentUnitNumber;
        Unit unit;
        boolean qualifierMatches = false;
        String unitNumber = qualification.get("unitNumber");
        while (!qualifierMatches && (unit = this.unitService.getUnit(unitNumber)) != null && (parentUnitNumber = unit.getParentUnitNumber()) != null) {
            qualifierMatches = StringUtils.equals((String)parentUnitNumber, (String)roleQualifier.get("unitNumber")) && this.descendsSubunits(roleQualifier);
            unitNumber = parentUnitNumber;
        }
        return qualifierMatches;
    }

    protected boolean descendsSubunits(Map<String, String> roleQualifier) {
        return StringUtils.equalsIgnoreCase((String)"Y", (String)roleQualifier.get("subunits")) || StringUtils.equalsIgnoreCase((String)"Yes", (String)roleQualifier.get("subunits"));
    }

    protected boolean performWildCardMatching(Map<String, String> qualification, Map<String, String> roleQualifier) {
        return qualification.get("unitNumber").equalsIgnoreCase("*");
    }

    public List<String> getUniqueAttributes(String kimTypeId) {
        return new ArrayList<String>();
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        ArrayList<KimAttributeField> attributeList = new ArrayList<KimAttributeField>(super.getAttributeDefinitions(kimTypeId));
        for (int i = 0; i < attributeList.size(); ++i) {
            KimAttributeField definition = (KimAttributeField)attributeList.get(i);
            if (!"unitNumber".equals(definition.getAttributeField().getName())) continue;
            KimAttributeField.Builder b = KimAttributeField.Builder.create((KimAttributeFieldContract)definition);
            String baseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.lookup.url");
            ArrayList<Object> widgetsCopy = new ArrayList<Object>();
            for (RemotableAbstractWidget.Builder widget : b.getAttributeField().getWidgets()) {
                if (widget instanceof RemotableQuickFinder.Builder) {
                    RemotableQuickFinder.Builder orig = (RemotableQuickFinder.Builder)widget;
                    RemotableQuickFinder.Builder copy = RemotableQuickFinder.Builder.create((String)baseUrl, (String)orig.getDataObjectClass());
                    copy.setLookupParameters(orig.getLookupParameters());
                    copy.setFieldConversions(orig.getFieldConversions());
                    widgetsCopy.add(copy);
                    continue;
                }
                widgetsCopy.add(widget);
            }
            b.getAttributeField().setWidgets(widgetsCopy);
            attributeList.set(i, b.build());
        }
        return Collections.unmodifiableList(attributeList);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

