/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimAttributeFieldContract;
import org.kuali.rice.kns.kim.role.RoleTypeServiceBase;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class UnitRoleTypeServiceImpl
extends RoleTypeServiceBase {
    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        List<Object> validationErrors = new ArrayList<RemotableAttributeError>();
        if (this.roleQualifiedByProposalKey(attributes) || this.roleQualifiedByProtocolKey(attributes) || this.roleQualifiedByCommitteeKey(attributes) || this.roleQualifiedByAwardKey(attributes) || this.roleQualifiedByAwardKey(attributes)) {
            return validationErrors;
        }
        if (this.roleQualifiedByUnitOnly(attributes)) {
            validationErrors = super.validateAttributes(kimTypeId, attributes);
        }
        return validationErrors;
    }

    public boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (this.roleQualifiedByProposalKey(roleQualifier)) {
            return qualification.containsKey("proposal") && StringUtils.equals((String)qualification.get("proposal"), (String)roleQualifier.get("proposal"));
        }
        if (this.roleQualifiedByProtocolKey(roleQualifier)) {
            return qualification.containsKey("protocol") && StringUtils.equals((String)qualification.get("protocol"), (String)roleQualifier.get("protocol"));
        }
        if (this.roleQualifiedByCommitteeKey(roleQualifier)) {
            return qualification.containsKey("committee") && StringUtils.equals((String)qualification.get("committee"), (String)roleQualifier.get("committee"));
        }
        if (this.roleQualifiedByAwardKey(roleQualifier)) {
            return qualification.containsKey("award") && StringUtils.equals((String)qualification.get("award"), (String)roleQualifier.get("award"));
        }
        if (this.roleQualifiedByTimeAndMoneyKey(roleQualifier)) {
            return qualification.containsKey("timeandmoney") && StringUtils.equals((String)qualification.get("timeandmoney"), (String)roleQualifier.get("timeandmoney"));
        }
        if (this.roleQualifiedByUnitOnly(roleQualifier)) {
            return qualification.containsKey("unitNumber") && StringUtils.equals((String)qualification.get("unitNumber"), (String)roleQualifier.get("unitNumber")) || this.performWildCardMatching(qualification, roleQualifier);
        }
        return false;
    }

    protected boolean roleQualifiedByProposalKey(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("proposal");
    }

    protected boolean roleQualifiedByProtocolKey(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("protocol");
    }

    protected boolean roleQualifiedByCommitteeKey(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("committee");
    }

    protected boolean roleQualifiedByAwardKey(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("award");
    }

    protected boolean roleQualifiedByTimeAndMoneyKey(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("timeandmoney");
    }

    protected boolean roleQualifiedByUnitOnly(Map<String, String> roleQualifier) {
        return roleQualifier.containsKey("unitNumber") && !roleQualifier.containsKey("subunits");
    }

    protected boolean performWildCardMatching(Map<String, String> qualification, Map<String, String> roleQualifier) {
        return qualification.containsKey("unitNumber") && qualification.get("unitNumber").equalsIgnoreCase("*") && roleQualifier.containsKey("unitNumber");
    }

    public List<String> getQualifiersForExactMatch() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("proposal");
        attributes.add("protocol");
        attributes.add("committee");
        attributes.add("award");
        attributes.add("timeandmoney");
        attributes.add("unitNumber");
        return attributes;
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        ArrayList<KimAttributeField> attributeList = new ArrayList<KimAttributeField>(super.getAttributeDefinitions(kimTypeId));
        for (int i = 0; i < attributeList.size(); ++i) {
            KimAttributeField definition = (KimAttributeField)attributeList.get(i);
            if (!"unitNumber".equals(definition.getAttributeField().getName())) continue;
            KimAttributeField.Builder b = KimAttributeField.Builder.create((KimAttributeFieldContract)definition);
            String baseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.lookup.url");
            ArrayList<Object> widgetsCopy = new ArrayList<Object>();
            for (RemotableAbstractWidget.Builder widget : b.getAttributeField().getWidgets()) {
                if (widget instanceof RemotableQuickFinder.Builder) {
                    RemotableQuickFinder.Builder orig = (RemotableQuickFinder.Builder)widget;
                    RemotableQuickFinder.Builder copy = RemotableQuickFinder.Builder.create((String)baseUrl, (String)orig.getDataObjectClass());
                    copy.setLookupParameters(orig.getLookupParameters());
                    copy.setFieldConversions(orig.getFieldConversions());
                    widgetsCopy.add(copy);
                    continue;
                }
                widgetsCopy.add(widget);
            }
            b.getAttributeField().setWidgets(widgetsCopy);
            attributeList.set(i, b.build());
        }
        return Collections.unmodifiableList(attributeList);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

