/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.krms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;

public abstract class FunctionTermResolver
implements TermResolver<Object> {
    private List<String> orderedInputParams;
    private String output;
    private Set<String> parameterNames;
    private FunctionDefinition functionTerm;

    public FunctionTermResolver(List<String> orderedInputParams, Set<String> parameterNames, String output) {
        this.orderedInputParams = orderedInputParams;
        this.parameterNames = parameterNames;
        this.output = output;
    }

    public List<String> getOrderedInputParams() {
        return this.orderedInputParams;
    }

    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        for (String param : this.orderedInputParams) {
            if (this.parameterNames.contains(param)) continue;
            prereqs.add(param);
        }
        return new HashSet<String>(prereqs);
    }

    public String getOutput() {
        return this.output;
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public int getCost() {
        return 1;
    }

    public Object resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
        String krmsTypeId = this.getFunctionTerm().getTypeId();
        String serviceName = null;
        if (krmsTypeId != null) {
            KrmsTypeDefinition typeDefinition = KrmsApiServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
            serviceName = typeDefinition.getServiceName();
        }
        String methodName = this.getFunctionTerm().getName();
        Object result = this.executeFunction(serviceName, methodName, resolvedPrereqs, parameters);
        return result;
    }

    protected abstract Object executeFunction(String var1, String var2, Map<String, Object> var3, Map<String, String> var4);

    protected List<Object> extractParamValues(Map<String, Object> resolvedPrereqs, Map<String, String> resolvedParameters) {
        List parameters = this.getOrderedInputParams();
        ArrayList<Object> extractedParams = new ArrayList<Object>();
        for (String parameter : parameters) {
            Object paramValue = resolvedPrereqs.get(parameter);
            if (paramValue == null) {
                paramValue = resolvedParameters.get(parameter);
            }
            extractedParams.add(paramValue);
        }
        return extractedParams;
    }

    public FunctionDefinition getFunctionTerm() {
        return this.functionTerm;
    }

    public void setFunctionTerm(FunctionDefinition functionTerm) {
        this.functionTerm = functionTerm;
    }
}

