/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.logging;

import java.lang.reflect.Method;
import java.util.Collection;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.kuali.kra.logging.BufferedLogger;

class TraceInvocationHandler
implements MethodInterceptor {
    private static final String TRACE_START = "************************* %s#%s TRACE START **************************";
    private static final String TRACE_END = "************************* %s TRACE END   **************************";
    private static final String LINE = "*******************************************************************";
    private static final String ENTERING_METH_MSG = "Entering method %s with parameters:";
    private static final String ENTERING_METH_MSG_2 = "Entering method %s without parameters";
    private static final String METHOD_PARAM_MSG = "Parameter Type: %s, Value: %s";
    private static final String RETURN_METH_MSG = "Returning from method %s with Value: %s";
    private static final String RETURN_METH_MSG_2 = "Returning from method %s";
    private Object archetype;

    public TraceInvocationHandler() {
        this(null);
    }

    public TraceInvocationHandler(Object archetype) {
        this.archetype = archetype;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        BufferedLogger.trace((Object[])new Object[]{TRACE_START, method.getDeclaringClass().getSimpleName(), method.getName()});
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Object arg = args[i];
            BufferedLogger.trace((Object[])new Object[]{METHOD_PARAM_MSG, paramType.getSimpleName(), this.getArgValue(paramType, arg)});
        }
        BufferedLogger.trace((Object[])new Object[]{LINE});
        Object retval = null;
        retval = this.archetype != null ? proxy.invoke(this.archetype, args) : proxy.invokeSuper(obj, args);
        if (method.getReturnType() != Void.TYPE) {
            BufferedLogger.trace((Object[])new Object[]{RETURN_METH_MSG, method.getName(), retval});
        } else {
            BufferedLogger.trace((Object[])new Object[]{RETURN_METH_MSG_2, method.getName()});
        }
        BufferedLogger.trace((Object[])new Object[]{LINE});
        BufferedLogger.trace((Object[])new Object[]{TRACE_END, method.getName()});
        return retval;
    }

    private String getArgValue(Class paramType, Object arg) {
        StringBuffer retval = new StringBuffer();
        if (paramType.isArray()) {
            retval.append(this.getArrayArgValue((Object[])arg));
        } else {
            retval.append(arg);
        }
        if (Collection.class.isAssignableFrom(paramType)) {
            retval.append("size = ").append(((Collection)arg).size());
        }
        return retval.toString();
    }

    private String getArrayArgValue(Object[] arg) {
        StringBuffer retval = new StringBuffer("{");
        for (Object obj : arg) {
            retval.append(this.getArgValue(obj.getClass(), obj)).append(",");
        }
        retval.deleteCharAt(retval.length() - 1);
        retval.append("}");
        return retval.toString();
    }
}

