/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.logging;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.logging.TraceInvocationHandler;
import org.kuali.kra.logging.Traceable;

public class TraceLogProxyFactory {
    private static final String CLASS_NOT_INSTANTIABLE = "Could not create an instance of class %s\n";

    public static <T> T getProxyFor(Class<T> target) {
        if (target == null) {
            throw new IllegalArgumentException("Can't proxy a null value");
        }
        T retval = null;
        if (Traceable.class.isAssignableFrom(target) && LogFactory.getLog(target).isTraceEnabled()) {
            Class<T> targetClass = target;
            if (Enhancer.isEnhanced(target)) {
                targetClass = target.getSuperclass();
            }
            return (T)Enhancer.create(targetClass, (Class[])new Class[]{Traceable.class}, (Callback)new TraceInvocationHandler());
        }
        try {
            retval = target.newInstance();
        }
        catch (Exception e) {
            BufferedLogger.error((Object[])new Object[]{CLASS_NOT_INSTANTIABLE, target.getSimpleName()});
            e.printStackTrace();
        }
        return retval;
    }

    public static <T> T getProxyFor(Traceable<T> target) {
        Class<?> targetClass = target.getClass();
        if (Enhancer.isEnhanced(targetClass)) {
            targetClass = target.getClass().getSuperclass();
        }
        if (!Traceable.class.isAssignableFrom(targetClass) || !LogFactory.getLog(targetClass).isTraceEnabled()) {
            return (T)target;
        }
        LogFactory.getLog(TraceLogProxyFactory.class).info((Object)"Returning proxy");
        return (T)Enhancer.create(targetClass, (Class[])new Class[]{Traceable.class}, (Callback)new TraceInvocationHandler(target));
    }
}

