/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;

public class BudgetPeriodLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    protected AwardBudgetService awardBudgetService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String awardNumber = fieldValues.get("budgetParentId");
        List budgetPeriods = this.getAwardBudgetService().findBudgetPeriodsFromLinkedProposal(awardNumber);
        this.filterSearchResults(budgetPeriods, fieldValues);
        return budgetPeriods;
    }

    protected void filterSearchResults(List<BudgetPeriod> budgetPeriods, Map<String, String> fieldValues) {
        String instPropNumber = fieldValues.get("institutionalProposalNumber");
        String instPropVersion = fieldValues.get("institutionalProposalVersion");
        String budgetPeriod = fieldValues.get("budgetPeriod");
        String totalCost = fieldValues.get("totalCost");
        String directCost = fieldValues.get("totalDirectCost");
        String indirectCost = fieldValues.get("totalIndirectCost");
        String costSharingAmt = fieldValues.get("costSharingAmount");
        String underrecoveryAmount = fieldValues.get("underrecoveryAmount");
        String comments = fieldValues.get("comments");
        ListIterator<BudgetPeriod> iter = budgetPeriods.listIterator();
        while (iter.hasNext()) {
            BudgetPeriod period = iter.next();
            if (StringUtils.isNotBlank((String)instPropNumber) && !StringUtils.equals((String)instPropNumber, (String)period.getInstitutionalProposalNumber())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)instPropVersion) && !StringUtils.equals((String)instPropVersion, (String)period.getInstitutionalProposalVersion().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)budgetPeriod) && !StringUtils.equals((String)budgetPeriod, (String)period.getBudgetPeriod().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)totalCost) && !StringUtils.equals((String)totalCost, (String)period.getTotalCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)directCost) && !StringUtils.equals((String)directCost, (String)period.getTotalDirectCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)indirectCost) && !StringUtils.equals((String)indirectCost, (String)period.getTotalIndirectCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)costSharingAmt) && !StringUtils.equals((String)costSharingAmt, (String)period.getCostSharingAmount().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((String)underrecoveryAmount) && !StringUtils.equals((String)underrecoveryAmount, (String)period.getUnderrecoveryAmount().toString())) {
                iter.remove();
                continue;
            }
            if (!StringUtils.isNotBlank((String)comments) || StringUtils.equals((String)comments, (String)period.getComments())) continue;
            iter.remove();
        }
    }

    protected AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }
}

