/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;

public class CustomAttributeLookupHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final String EQUAL_CHAR = "=";
    private Collection<String> documentTypeParam = this.getParameterService().getParameterValuesAsString("KC-GEN", "DocumentType", "customAttributeDocumentType");

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List searchResults = super.getSearchResults(fieldValues);
        Map documentTypes = this.getDocumentTypeMap();
        for (CustomAttributeDocument customAttributeDocument : searchResults) {
            customAttributeDocument.setDocumentTypeName((String)documentTypes.get(customAttributeDocument.getDocumentTypeName()));
        }
        return searchResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        Map documentTypes = this.getReverseDocumentTypeMap();
        for (HtmlData htmlData : htmlDataList) {
            String docType;
            if (!StringUtils.isNotBlank((String)((HtmlData.AnchorHtmlData)htmlData).getHref()) || !StringUtils.isNotBlank((String)(docType = StringUtils.substringBetween((String)((HtmlData.AnchorHtmlData)htmlData).getHref(), (String)"documentTypeName=", (String)"&"))) || !documentTypes.containsKey(docType)) continue;
            ((HtmlData.AnchorHtmlData)htmlData).setHref(((HtmlData.AnchorHtmlData)htmlData).getHref().replace(docType, (CharSequence)documentTypes.get(docType)));
        }
        return htmlDataList;
    }

    protected Map<String, String> getDocumentTypeMap() {
        HashMap<String, String> documentTypes = new HashMap<String, String>();
        for (String documentType : this.documentTypeParam) {
            String[] params = documentType.split(EQUAL_CHAR);
            documentTypes.put(params[0], params[1]);
        }
        return documentTypes;
    }

    protected Map<String, String> getReverseDocumentTypeMap() {
        HashMap<String, String> documentTypes = new HashMap<String, String>();
        for (String documentType : this.documentTypeParam) {
            String[] params = documentType.split(EQUAL_CHAR);
            documentTypes.put(params[1].replace(" ", "+"), params[0]);
        }
        return documentTypes;
    }
}

