/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.MultiCampusIdentityService;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class PersonLookupableHelperServiceImpl
extends org.kuali.rice.kim.lookup.PersonLookupableHelperServiceImpl {
    private static final long serialVersionUID = 5378644476985169785L;
    private static final String PRINCIPAL_NAME_FIELD = "principalName";
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String PERSON_CAMPUS_CODE_FIELD = "campusCode";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = "org.kuali.rice.location.impl.campus.CampusBo";
    private static final String PRIMARY_DEPARTMENT_CODE_FIELD = "primaryDepartmentCode";
    private static final String UNIT_NUMBER_FIELD = "unitNumber";
    private static final String UNIT_LOOKUPABLE_CLASS_NAME = "org.kuali.kra.bo.Unit";
    private MultiCampusIdentityService multiCampusIdentityService;

    public List<Row> getRows() {
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(PRIMARY_DEPARTMENT_CODE_FIELD)) {
                    field.setFieldConversions("unitNumber:" + field.getPropertyName());
                    field.setInquiryParameters(field.getPropertyName() + ":" + UNIT_NUMBER_FIELD);
                    field.setQuickFinderClassNameImpl(UNIT_LOOKUPABLE_CLASS_NAME);
                    field.setFieldDirectInquiryEnabled(true);
                    continue;
                }
                if (!field.getPropertyName().equals(PERSON_CAMPUS_CODE_FIELD)) continue;
                field.setFieldConversions("code:" + field.getPropertyName());
                field.setLookupParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setInquiryParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setQuickFinderClassNameImpl(CAMPUS_LOOKUPABLE_CLASS_NAME);
                field.setFieldDirectInquiryEnabled(true);
                if (!multiCampusEnabled || !StringUtils.isBlank((String)field.getDefaultValue())) continue;
                String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
                field.setDefaultValue(campusCode);
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return rows;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (multiCampusEnabled && StringUtils.isNotBlank((String)fieldValues.get(PRINCIPAL_NAME_FIELD))) {
            String principalName = fieldValues.get(PRINCIPAL_NAME_FIELD);
            String campusCode = fieldValues.get(PERSON_CAMPUS_CODE_FIELD);
            String multiCampusPrincipalName = this.getMultiCampusIdentityService().getMultiCampusPrincipalName(principalName, campusCode);
            fieldValues.put(PRINCIPAL_NAME_FIELD, multiCampusPrincipalName);
        }
        return super.getSearchResults(fieldValues);
    }

    public MultiCampusIdentityService getMultiCampusIdentityService() {
        if (this.multiCampusIdentityService == null) {
            this.multiCampusIdentityService = (MultiCampusIdentityService)KraServiceLocator.getService(MultiCampusIdentityService.class);
        }
        return this.multiCampusIdentityService;
    }

    public void setMultiCampusIdentityService(MultiCampusIdentityService multiCampusIdentityService) {
        this.multiCampusIdentityService = multiCampusIdentityService;
    }
}

