/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -3661085880649722426L;
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = "org.kuali.rice.location.impl.campus.CampusBo";
    private KcPersonService kcPersonService;
    private UnitAuthorizationService unitAuthorizationService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        String personId = this.getKcPersonService().getKcPersonByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId()).getPersonId();
        boolean hasModifyPermission = this.getUnitAuthorizationService().hasPermission(personId, "KC-UNT", "Modify Unit");
        if (hasModifyPermission) {
            HtmlData.AnchorHtmlData editHtmlData = this.getUrlData(businessObject, "edit", pkNames);
            htmlDataList.add((HtmlData)editHtmlData);
            HtmlData.AnchorHtmlData copyHtmlData = this.getUrlData(businessObject, "copy", pkNames);
            htmlDataList.add((HtmlData)copyHtmlData);
            HtmlData.AnchorHtmlData deleteHtmlData = this.getUrlData(businessObject, "delete", pkNames);
            htmlDataList.add((HtmlData)deleteHtmlData);
        }
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(CAMPUS_CODE_FIELD)) continue;
                field.setFieldConversions("code:" + field.getPropertyName());
                field.setLookupParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setInquiryParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setQuickFinderClassNameImpl(CAMPUS_LOOKUPABLE_CLASS_NAME);
                field.setFieldDirectInquiryEnabled(true);
                if (!multiCampusEnabled || !StringUtils.isBlank((String)field.getDefaultValue())) continue;
                String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
                field.setDefaultValue(campusCode);
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return rows;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String campusCode = fieldValues.remove(CAMPUS_CODE_FIELD);
        List searchResults = super.getSearchResults(fieldValues);
        ArrayList<Unit> filteredSearchResults = new ArrayList<Unit>();
        for (BusinessObject searchResult : searchResults) {
            Unit unit = (Unit)searchResult;
            if (!StringUtils.startsWith((String)unit.getUnitNumber(), (String)campusCode)) continue;
            filteredSearchResults.add(unit);
        }
        return filteredSearchResults;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

