/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class CountryCodeValuesFinder
extends KeyValuesBase {
    private String getDefaultCountryCode() {
        String postalCountryCode = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "All", "DEFAULT_COUNTRY");
        return postalCountryCode;
    }

    public List<KeyValue> getKeyValues() {
        CountryService countryService = (CountryService)KraServiceLocator.getService(CountryService.class);
        List countries = countryService.findAllCountries();
        Country defaultCountry = countryService.getCountry(this.getDefaultCountryCode());
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select: "));
        if (defaultCountry != null) {
            keyValues.add((KeyValue)new ConcreteKeyValue(defaultCountry.getAlternateCode(), defaultCountry.getName()));
        }
        for (Country country : countries) {
            keyValues.add((KeyValue)new ConcreteKeyValue(country.getAlternateCode(), country.getName()));
        }
        return keyValues;
    }
}

