/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KeyValueFinderServiceImpl
implements KeyValueFinderService {
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(KeyValueFinderServiceImpl.class);

    public List<KeyValue> getKeyValues(Class keyValClass, String codePropName, String valPropName) {
        Collection keyVals = this.businessObjectService.findAll(keyValClass);
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>(keyVals.size());
        keyValueList.add((KeyValue)new ConcreteKeyValue("", "select"));
        for (Object keyValObj : keyVals) {
            try {
                Method getCodeMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)codePropName), null);
                Method getValMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)valPropName), null);
                Object code = getCodeMeth.invoke(keyValObj, null);
                Object value = getValMeth.invoke(keyValObj, null);
                if (code == null || value == null) continue;
                keyValueList.add((KeyValue)new ConcreteKeyValue(code.toString(), value.toString()));
            }
            catch (SecurityException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
        }
        return keyValueList;
    }

    public List<KeyValue> getKeyValues(Class keyValClass, String codePropName, String valPropName, Map queryMap) {
        Collection keyVals = this.businessObjectService.findMatching(keyValClass, queryMap);
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>(keyVals.size());
        keyValueList.add((KeyValue)new ConcreteKeyValue("", "select:"));
        for (Object keyValObj : keyVals) {
            try {
                Method getCodeMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)codePropName), null);
                Method getValMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)valPropName), null);
                String code = (String)getCodeMeth.invoke(keyValObj, null);
                String value = (String)getValMeth.invoke(keyValObj, null);
                keyValueList.add((KeyValue)new ConcreteKeyValue(code, value));
            }
            catch (SecurityException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)e.getMessage());
            }
        }
        return keyValueList;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

