/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueComparator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class LookupableBoValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService(DataDictionaryService.class);
        Map businessObjectEntries = dataDictionaryService.getDataDictionary().getBusinessObjectEntries();
        Map labelCounts = this.getLabelCounts(businessObjectEntries);
        for (String businessObject : businessObjectEntries.keySet()) {
            ConcreteKeyValue KeyValue2;
            org.kuali.rice.kns.datadictionary.BusinessObjectEntry businessObjectEntry = (org.kuali.rice.kns.datadictionary.BusinessObjectEntry)businessObjectEntries.get(businessObject);
            if (!businessObjectEntry.hasLookupDefinition() || !businessObject.startsWith("org.kuali.kra") && !businessObject.equals("org.kuali.rice.location.impl.campus.CampusBo") && !businessObject.equals("org.kuali.rice.location.impl.country.CountryBo") && !businessObject.equals("org.kuali.rice.location.impl.county.CountyBo") && !businessObject.equals("org.kuali.rice.location.impl.postalcode.PostalCodeBo") && !businessObject.equals("org.kuali.rice.location.impl.state.StateBo")) continue;
            String key = businessObject;
            String label = StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
            if ((Integer)labelCounts.get(label) > 1) {
                label = label + " (" + key.toString().substring(key.toString().lastIndexOf(".") + 1) + ")";
            }
            if (keyValues.contains(KeyValue2 = new ConcreteKeyValue(key, label))) continue;
            keyValues.add((KeyValue)KeyValue2);
        }
        Collections.sort(keyValues, new KeyValueComparator());
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        return keyValues;
    }

    public Map<String, Integer> getLabelCounts(Map<String, BusinessObjectEntry> businessObjectEntries) {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        for (String businessObject : businessObjectEntries.keySet()) {
            org.kuali.rice.kns.datadictionary.BusinessObjectEntry businessObjectEntry = (org.kuali.rice.kns.datadictionary.BusinessObjectEntry)businessObjectEntries.get(businessObject);
            if (!businessObjectEntry.hasLookupDefinition() || !businessObject.startsWith("org.kuali.kra") && !businessObject.equals("org.kuali.rice.location.impl.campus.CampusBo") && !businessObject.equals("org.kuali.rice.location.impl.country.CountryBo") && !businessObject.equals("org.kuali.rice.location.impl.county.CountyBo") && !businessObject.equals("org.kuali.rice.location.impl.postalcode.PostalCodeBo") && !businessObject.equals("org.kuali.rice.location.impl.state.StateBo")) continue;
            String label = StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
            if (labels.containsKey(label)) {
                Integer count = (Integer)labels.get(label) + 1;
                labels.put(label, count);
                continue;
            }
            labels.put(label, 1);
        }
        return labels;
    }
}

