/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public final class PrefixValuesFinder
implements KeyValuesFinder {
    private static final String PREFIX_KEY = "";
    private static final String DEFAULT_PREFIX_VALUE = "select";
    private final KeyValuesFinder finder;
    private final String prefixValue;

    public PrefixValuesFinder(KeyValuesFinder finder) {
        this(finder, DEFAULT_PREFIX_VALUE);
    }

    public PrefixValuesFinder(KeyValuesFinder finder, String prefixValue) {
        if (finder == null) {
            throw new NullPointerException("the finder is null");
        }
        if (prefixValue == null) {
            throw new NullPointerException("the comparator is null");
        }
        this.finder = finder;
        this.prefixValue = prefixValue;
    }

    public String getKeyLabel(String key) {
        if (PREFIX_KEY.equals(key)) {
            return this.prefixValue;
        }
        return this.finder.getKeyLabel(key);
    }

    public Map<String, String> getKeyLabelMap() {
        Map map = this.finder.getKeyLabelMap();
        map.put(PREFIX_KEY, this.prefixValue);
        return map;
    }

    public List<KeyValue> getKeyValues() {
        List list = this.finder.getKeyValues();
        list.add(0, new ConcreteKeyValue(PREFIX_KEY, this.prefixValue));
        return list;
    }

    public static String getPrefixKey() {
        return PREFIX_KEY;
    }

    public static String getDefaultPrefixValue() {
        return DEFAULT_PREFIX_VALUE;
    }

    public List<KeyValue> getKeyValues(boolean includeActiveOnly) {
        List list = this.finder.getKeyValues(includeActiveOnly);
        list.add(0, new ConcreteKeyValue(PREFIX_KEY, this.prefixValue));
        return list;
    }

    public void clearInternalCache() {
        this.finder.clearInternalCache();
    }
}

