/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.kuali.kra.lookup.keyvalue.KeyValueComparator;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public final class SortedValuesFinder
implements KeyValuesFinder {
    private static final Comparator<KeyValue> DEFAULT_COMPARATOR = KeyValueComparator.getInstance();
    private final KeyValuesFinder finder;
    private final Comparator<KeyValue> comparator;

    public SortedValuesFinder(KeyValuesFinder finder) {
        this(finder, DEFAULT_COMPARATOR);
    }

    public SortedValuesFinder(KeyValuesFinder finder, Comparator<KeyValue> comparator) {
        if (finder == null) {
            throw new NullPointerException("the finder is null");
        }
        if (comparator == null) {
            throw new NullPointerException("the comparator is null");
        }
        this.finder = finder;
        this.comparator = comparator;
    }

    public String getKeyLabel(String key) {
        return this.finder.getKeyLabel(key);
    }

    public Map<String, String> getKeyLabelMap() {
        Map map = this.finder.getKeyLabelMap();
        return map;
    }

    public List<KeyValue> getKeyValues() {
        List list = this.finder.getKeyValues();
        Collections.sort(list, this.comparator);
        return list;
    }

    public static Comparator<KeyValue> getDefaultComparator() {
        return DEFAULT_COMPARATOR;
    }

    public List<KeyValue> getKeyValues(boolean includeActiveOnly) {
        List list = this.finder.getKeyValues(includeActiveOnly);
        Collections.sort(list, this.comparator);
        return list;
    }

    public void clearInternalCache() {
        this.finder.clearInternalCache();
    }
}

