/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.medusa;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.medusa.MedusaNode;
import org.kuali.kra.medusa.MedusaNodeComparator;
import org.kuali.kra.medusa.service.MedusaService;

public class MedusaBean
implements Serializable {
    private static final long serialVersionUID = -8727199559530816767L;
    private String medusaViewRadio;
    private String moduleName;
    private Long moduleIdentifier;
    private List<MedusaNode> parentNodes;
    private MedusaNode currentNode;

    public MedusaBean() {
        this.setMedusaViewRadio("0");
    }

    public String getMedusaViewRadio() {
        return this.medusaViewRadio;
    }

    public void setMedusaViewRadio(String medusaViewRadio) {
        if (!StringUtils.equals((String)this.medusaViewRadio, (String)medusaViewRadio)) {
            this.medusaViewRadio = medusaViewRadio;
            this.generateParentNodes();
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Long getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public void setModuleIdentifier(Long moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
    }

    private MedusaService getMedusaService() {
        return (MedusaService)KraServiceLocator.getService(MedusaService.class);
    }

    public void generateParentNodes() {
        if (StringUtils.equalsIgnoreCase((String)"0", (String)this.getMedusaViewRadio())) {
            this.setParentNodes(this.getMedusaService().getMedusaByProposal(this.getModuleName(), this.getModuleIdentifier()));
        } else if (StringUtils.equalsIgnoreCase((String)"1", (String)this.getMedusaViewRadio())) {
            this.setParentNodes(this.getMedusaService().getMedusaByAward(this.getModuleName(), this.getModuleIdentifier()));
        }
        this.sortNodes(this.parentNodes);
    }

    public List<MedusaNode> getParentNodes() {
        if (this.parentNodes == null) {
            this.generateParentNodes();
        }
        return this.parentNodes;
    }

    private void sortNodes(List<MedusaNode> nodes) {
        Collections.sort(nodes, new MedusaNodeComparator());
        for (MedusaNode mNode : nodes) {
            if (mNode.getChildNodes().isEmpty()) continue;
            this.sortNodes(mNode.getChildNodes());
        }
    }

    public void setParentNodes(List<MedusaNode> parentNodes) {
        this.parentNodes = parentNodes;
    }

    public MedusaNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(MedusaNode currentNode) {
        this.currentNode = currentNode;
    }
}

