/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.medusa;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.medusa.MedusaNode;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.krad.bo.BusinessObject;

public class MedusaNodeComparator
implements Comparator<MedusaNode> {
    @Override
    public int compare(MedusaNode m1, MedusaNode m2) {
        return this.getNodeValue(m1).compareTo(this.getNodeValue(m2));
    }

    private String getNodeValue(MedusaNode m) {
        String nodeType = m.getType();
        BusinessObject mBo = m.getBo();
        if (!StringUtils.isNotBlank((String)nodeType) || mBo == null) {
            return "medusa: unknown medusa node type";
        }
        if (StringUtils.equals((String)nodeType, (String)"award")) {
            return nodeType + ((Award)mBo).getAwardNumber();
        }
        if (StringUtils.equals((String)nodeType, (String)"IP")) {
            return nodeType + ((InstitutionalProposal)mBo).getProposalNumber();
        }
        if (StringUtils.equals((String)nodeType, (String)"DP")) {
            return nodeType + ((DevelopmentProposal)mBo).getProposalNumber();
        }
        if (StringUtils.equals((String)nodeType, (String)"neg")) {
            return nodeType + ((Negotiation)mBo).getNegotiationId();
        }
        if (StringUtils.equals((String)nodeType, (String)"subaward")) {
            return nodeType + ((SubAward)mBo).getSubAwardId();
        }
        return "medusa: unsupported medusa node type";
    }
}

