/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.negotiations.bo.NegotiationsGroupingBase;
import org.kuali.kra.rules.ErrorReporter;

public class NegotiationsMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = -4054390064236611181L;

    public void prepareForSave() {
        NegotiationsGroupingBase negotiationBase = (NegotiationsGroupingBase)this.businessObject;
        boolean isNew = negotiationBase.getId() == null;
        this.validateCode(negotiationBase, isNew);
        super.prepareForSave();
    }

    private void validateCode(NegotiationsGroupingBase negotiationBase, boolean isNew) {
        Collection dbCollection = this.getBusinessObjectService().findAll(negotiationBase.getClass());
        for (NegotiationsGroupingBase dbBase : dbCollection) {
            if (isNew) {
                if (!StringUtils.equalsIgnoreCase((String)negotiationBase.getCode(), (String)dbBase.getCode())) continue;
                this.reportError(negotiationBase.getCode());
                continue;
            }
            if (negotiationBase.getId().equals(dbBase.getId()) || !StringUtils.equalsIgnoreCase((String)negotiationBase.getCode(), (String)dbBase.getCode())) continue;
            this.reportError(negotiationBase.getCode());
        }
    }

    private void reportError(String codeValue) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.code", "error.negotiations.codeAlreadyUsed", new String[]{codeValue});
    }
}

