/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.document;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

@ParameterConstants.NAMESPACE(namespace="KC-NEGOTIATION")
@ParameterConstants.COMPONENT(component="Document")
public class NegotiationDocument
extends ResearchDocumentBase
implements Serializable {
    private static final long serialVersionUID = 2635757819118105L;
    public static final String DOCUMENT_TYPE_CODE = "NGT";
    private List<Negotiation> negotiationList = new ArrayList();
    private String docStatusCode;

    public NegotiationDocument() {
        this.negotiationList.add(new Negotiation());
    }

    public NegotiationDocument newInstance() {
        return new NegotiationDocument();
    }

    public void initialize() {
        super.initialize();
    }

    public Negotiation getNegotiation() {
        if (this.getNegotiationList().isEmpty()) {
            this.getNegotiationList().add(new Negotiation());
        }
        return (Negotiation)this.getNegotiationList().get(0);
    }

    public String getDocStatusCode() {
        return this.docStatusCode;
    }

    public void setDocStatusCode(String docStatusCode) {
        this.docStatusCode = docStatusCode;
    }

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public void prepareForSave() {
        String routeStatusCode;
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        if (StringUtils.isNotBlank((String)(routeStatusCode = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) && routeStatusCode.equals("I")) {
            this.setDocStatusCode("S");
        } else {
            this.setDocStatusCode(routeStatusCode);
        }
    }

    private boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)"F", (String)statusChangeEvent.getNewRouteStatus());
    }

    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.negotiationList);
        managedLists.add(this.getNegotiation().getActivities());
        ArrayList attachments = new ArrayList();
        for (NegotiationActivity activity : this.getNegotiation().getActivities()) {
            attachments.addAll(activity.getAttachments());
        }
        managedLists.add(attachments);
        return managedLists;
    }

    public List<Negotiation> getNegotiationList() {
        return this.negotiationList;
    }

    public void setNegotiationList(List<Negotiation> negotiationList) {
        this.negotiationList = negotiationList;
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getNegotiation().getNegotiationCustomDataList();
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getNegotiation().getNegotiationId() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }
}

