/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.negotiations.auth.NegotiationTask;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class NegotiationDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        NegotiationDocument negotiationDocument = (NegotiationDocument)document;
        if (negotiationDocument.getNegotiation().getNegotiationId() == null) {
            if (this.canCreateNegotiation(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else if (this.canExecuteNegotiationTask(userId, negotiationDocument, "modifyNegotiation") || this.canExecuteNegotiationTask(userId, negotiationDocument, "modifyNegotiationActivities")) {
            editModes.add("fullEntry");
        } else if (this.canExecuteNegotiationTask(userId, negotiationDocument, "viewNegotiation")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        this.setPermissions(user, negotiationDocument, editModes);
        return editModes;
    }

    protected void setPermissions(Person user, NegotiationDocument negotiationDoc, Set<String> editModes) {
        if (this.canCreateNegotiation(user)) {
            editModes.add("create");
        }
        if (this.canExecuteNegotiationTask(user.getPrincipalId(), negotiationDoc, "modifyNegotiation")) {
            editModes.add("modify");
        }
        if (this.canExecuteNegotiationTask(user.getPrincipalId(), negotiationDoc, "createNegotiationActivities")) {
            editModes.add("create_activity");
        }
        if (this.canExecuteNegotiationTask(user.getPrincipalId(), negotiationDoc, "modifyNegotiationActivities")) {
            editModes.add("modify_activity");
        }
        if (this.canExecuteNegotiationTask(user.getPrincipalId(), negotiationDoc, "viewNegotiation")) {
            editModes.add("view");
        }
        if (this.canExecuteNegotiationTask(user.getPrincipalId(), negotiationDoc, "viewNegotiationUnRestricted")) {
            editModes.add("view_unrestricted");
        }
    }

    private boolean canCreateNegotiation(Person user) {
        ApplicationTask task = new ApplicationTask("createNegotiation");
        boolean retVal = this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), (Task)task);
        return retVal;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateNegotiation(user);
    }

    public boolean canOpen(Document document, Person user) {
        boolean retVal = this.canExecuteNegotiationTask(user.getPrincipalId(), (NegotiationDocument)document, "viewNegotiation");
        return retVal;
    }

    private boolean canExecuteNegotiationTask(String userId, NegotiationDocument negotiation, String taskName) {
        NegotiationTask modifyActivitiesTask = new NegotiationTask(taskName, negotiation);
        return this.getTaskAuthorizationService().isAuthorized(userId, (Task)modifyActivitiesTask);
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteNegotiationTask(user.getPrincipalId(), (NegotiationDocument)document, "modifyNegotiation") || this.canExecuteNegotiationTask(user.getPrincipalId(), (NegotiationDocument)document, "modifyNegotiationActivities") || this.canExecuteNegotiationTask(user.getPrincipalId(), (NegotiationDocument)document, "createNegotiationActivities");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canReload(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document, user) && !workflowDocument.isInitiated();
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

