/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.rules.NegotiationActivityAddRule;
import org.kuali.kra.negotiations.rules.NegotiationActivityAddRuleEvent;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivityRuleImpl
implements NegotiationActivityAddRule {
    private static final String START_DATE_PROPERTY = "startDate";
    private static final String END_DATE_PROPERTY = "endDate";
    private final ErrorReporter errorReporter = new ErrorReporter();

    public boolean processAddNegotiationActivityRule(NegotiationActivityAddRuleEvent event) {
        boolean result = true;
        NegotiationDocument negotiationDoc = (NegotiationDocument)event.getDocument();
        Negotiation negotiation = negotiationDoc.getNegotiation();
        NegotiationActivity newActivity = event.getNewActivity();
        GlobalVariables.getMessageMap().addToErrorPath(event.getErrorPathPrefix());
        GlobalVariables.getMessageMap().removeFromErrorPath(event.getErrorPathPrefix());
        return result &= this.validateNegotiationActivity(newActivity, negotiation);
    }

    public boolean validateNegotiationActivity(NegotiationActivity activity, Negotiation negotiation) {
        boolean result = true;
        activity.refreshReferenceObject("activityType");
        if (activity.getActivityType() == null) {
            result = false;
            this.errorReporter.reportError("activityTypeId", "error.required", new String[]{"Activity Type (Activity Type)"});
        }
        activity.refreshReferenceObject("location");
        if (activity.getLocation() == null) {
            result = false;
            this.errorReporter.reportError("locationId", "error.required", new String[]{"Location (Location)"});
        }
        if (activity.getStartDate() == null) {
            result = false;
            this.errorReporter.reportError(START_DATE_PROPERTY, "error.required", new String[]{"Activity Start Date (Activity Start Date)"});
        }
        if (StringUtils.isBlank((String)activity.getDescription())) {
            result = false;
            this.errorReporter.reportError("description", "error.required", new String[]{"Activity Description (Activity Description)"});
        }
        if (activity.getStartDate() != null && negotiation.getNegotiationStartDate() != null && activity.getStartDate().compareTo(negotiation.getNegotiationStartDate()) < 0) {
            result = false;
            this.errorReporter.reportError(START_DATE_PROPERTY, "negotiation.error.activity.start.before.negotiation.start", new String[0]);
        }
        if (activity.getStartDate() != null && activity.getEndDate() != null && activity.getStartDate().compareTo(activity.getEndDate()) > 0) {
            result = false;
            this.errorReporter.reportError(END_DATE_PROPERTY, "negotiation.error.activity.start.before.end", new String[0]);
        }
        if (activity.getEndDate() != null && negotiation.getNegotiationEndDate() != null && activity.getEndDate().compareTo(negotiation.getNegotiationEndDate()) > 0) {
            result = false;
            this.errorReporter.reportError(END_DATE_PROPERTY, "negotiation.error.activity.end.after.negotiation.end", new String[0]);
        }
        if (activity.getFollowupDate() != null) {
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            if (activity.getFollowupDate().compareTo(today.getTime()) < 0) {
                result = false;
                this.errorReporter.reportError("followupDate", "negotiation.error.followup.date.before.today", new String[0]);
            }
        }
        return result;
    }
}

