/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.kim.service.impl.UnitAdministratorDerivedRoleTypeServiceImpl;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityHistoryLineBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociatedDetailBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationServiceImpl
implements NegotiationService {
    private static final String PARAMETER_DELIMITER = ",";
    private ParameterService parameterService;
    private AwardBudgetService awardBudgetService;
    private InstitutionalProposalService institutionalProposalService;
    private UnitAdministratorDerivedRoleTypeServiceImpl unitAdministratorDerivedRoleTypeServiceImpl;
    private KcPersonService kcPersonService;
    private VersionHistoryService versionHistoryService;
    private BusinessObjectService businessObjectService;

    public List<String> getInProgressStatusCodes() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "negotiationInProgressStatusCodes");
        return Arrays.asList(value.split(PARAMETER_DELIMITER));
    }

    public List<String> getCompletedStatusCodes() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "negotiationCompletedStatusCodes");
        return Arrays.asList(value.split(PARAMETER_DELIMITER));
    }

    public String getCompleteStatusCode() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "CLOSED_NEGOTIATION_STATUS");
        return value;
    }

    public Negotiable getAssociatedObject(Negotiation negotiation) {
        if (negotiation != null && negotiation.getNegotiationAssociationType() != null) {
            Award bo = null;
            if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"AWD")) {
                bo = this.getAward(negotiation.getAssociatedDocumentId());
            } else if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"IP")) {
                bo = this.getInstitutionalProposal(negotiation.getAssociatedDocumentId());
            } else if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"NO")) {
                negotiation.refreshReferenceObject("unAssociatedDetail");
                bo = negotiation.getUnAssociatedDetail();
            } else if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"PL")) {
                bo = this.getProposalLog(negotiation.getAssociatedDocumentId());
            } else if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"SWD")) {
                bo = this.getSubAward(negotiation.getAssociatedDocumentId());
            }
            return bo;
        }
        return null;
    }

    public NegotiationAssociatedDetailBean buildNegotiationAssociatedDetailBean(Negotiation negotiation) {
        negotiation.refreshReferenceObject("negotiationAssociationType");
        if (negotiation.getNegotiationAssociationType() != null) {
            Negotiable negotiable = negotiation.getAssociatedDocument();
            NegotiationAssociatedDetailBean bean = new NegotiationAssociatedDetailBean(negotiable);
            return bean;
        }
        return new NegotiationAssociatedDetailBean("");
    }

    private Award getAward(String awardNumber) {
        Award award = this.getAwardBudgetService().getActiveOrNewestAward(awardNumber);
        return award;
    }

    private ProposalLog getProposalLog(String proposalNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("PROPOSAL_NUMBER", proposalNumber);
        ProposalLog pl = (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, primaryKeys);
        return pl;
    }

    private SubAward getSubAward(String subAwardId) {
        VersionHistory versionHistory = this.getVersionHistoryService().getActiveOrNewestVersion(SubAward.class, subAwardId);
        if (versionHistory != null) {
            return (SubAward)versionHistory.getSequenceOwner();
        }
        return null;
    }

    private InstitutionalProposal getInstitutionalProposal(String proposalNumber) {
        InstitutionalProposal ip = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(proposalNumber);
        if (ip == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("PROPOSAL_NUMBER", proposalNumber);
            Collection proposals = this.businessObjectService.findMatching(InstitutionalProposal.class, params);
            if (proposals != null && proposals.size() > 0) {
                ip = (InstitutionalProposal)proposals.iterator().next();
            }
        }
        return ip;
    }

    public List<Negotiation> getAssociatedNegotiations(BusinessObject bo) {
        ArrayList<Negotiation> result = new ArrayList<Negotiation>();
        if (bo instanceof ProposalLog) {
            ProposalLog propLog = (ProposalLog)bo;
            return new ArrayList<Negotiation>(this.getAssociatedNegotiations(propLog.getProposalNumber(), "PL"));
        }
        if (bo instanceof InstitutionalProposal) {
            InstitutionalProposal ip = (InstitutionalProposal)bo;
            return new ArrayList<Negotiation>(this.getAssociatedNegotiations(ip.getProposalNumber(), "IP"));
        }
        if (bo instanceof Award) {
            Award award = (Award)bo;
            return new ArrayList<Negotiation>(this.getAssociatedNegotiations(award.getAwardNumber(), "AWD"));
        }
        if (bo instanceof SubAward) {
            SubAward subAward = (SubAward)bo;
            return new ArrayList<Negotiation>(this.getAssociatedNegotiations(subAward.getSubAwardCode(), "SWD"));
        }
        return result;
    }

    protected Collection<Negotiation> getAssociatedNegotiations(String associatedId, String associationTypeCode) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("associatedDocumentId", associatedId);
        values.put("negotiationAssociationTypeId", this.getNegotiationAssociationType(associationTypeCode).getId());
        return this.getBusinessObjectService().findMatching(Negotiation.class, values);
    }

    public NegotiationAssociationType getNegotiationAssociationType(String associationTypeCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", associationTypeCode);
        return (NegotiationAssociationType)this.getBusinessObjectService().findMatching(NegotiationAssociationType.class, params).iterator().next();
    }

    public NegotiationStatus getNegotiationStatus(String statusCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", statusCode);
        return (NegotiationStatus)this.getBusinessObjectService().findMatching(NegotiationStatus.class, params).iterator().next();
    }

    public boolean isAwardLinkingEnabled() {
        return this.isNegotaitionAssociationTypeActive("AWD");
    }

    public boolean isInstitutionalProposalLinkingEnabled() {
        return this.isNegotaitionAssociationTypeActive("IP");
    }

    public boolean isNoModuleLinkingEnabled() {
        return this.isNegotaitionAssociationTypeActive("NO");
    }

    public boolean isProposalLogLinkingEnabled() {
        return this.isNegotaitionAssociationTypeActive("PL");
    }

    public boolean isSubawardLinkingEnabled() {
        return this.isNegotaitionAssociationTypeActive("SWD");
    }

    protected boolean isNegotaitionAssociationTypeActive(String associationTypeCode) {
        NegotiationAssociationType nat = this.getNegotiationAssociationType(associationTypeCode);
        return nat.isActive();
    }

    public void checkForPropLogPromotion(Negotiation negotiation) {
        ProposalLog propLog;
        if (negotiation.getNegotiationAssociationType() != null && StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"PL") && this.isInstitutionalProposalLinkingEnabled() && (propLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)negotiation.getAssociatedDocumentId())) != null && StringUtils.isNotBlank((String)propLog.getInstProposalNumber())) {
            negotiation.setNegotiationAssociationType(this.getNegotiationAssociationType("IP"));
            InstitutionalProposal proposal = (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)propLog.getInstProposalNumber());
            if (proposal != null) {
                negotiation.setNegotiationAssociationTypeId(negotiation.getNegotiationAssociationType().getId());
                negotiation.setAssociatedDocumentId(proposal.getProposalNumber());
            }
        }
    }

    public boolean isPersonIsAssociatedPerson(Negotiation negotiation, String personToCheckPersonId) {
        Negotiable bo = this.getAssociatedObject(negotiation);
        if (bo != null) {
            for (NegotiationPersonDTO person : bo.getProjectPeople()) {
                if (!StringUtils.equals((String)person.getPerson().getPersonId(), (String)personToCheckPersonId)) continue;
                return true;
            }
        }
        return false;
    }

    public NegotiationUnassociatedDetail findAndLoadNegotiationUnassociatedDetail(Negotiation negotiation) {
        if (negotiation.getNegotiationAssociationType() != null && StringUtils.equalsIgnoreCase((String)negotiation.getNegotiationAssociationType().getCode(), (String)"NO") && StringUtils.isNotEmpty((String)negotiation.getAssociatedDocumentId()) && negotiation.getAssociatedDocumentId().matches("\\d*")) {
            NegotiationUnassociatedDetail unAssociatedDetail = (NegotiationUnassociatedDetail)this.getBusinessObjectService().findBySinglePrimaryKey(NegotiationUnassociatedDetail.class, (Object)negotiation.getAssociatedDocumentId());
            return unAssociatedDetail;
        }
        return null;
    }

    public List<NegotiationActivityHistoryLineBean> getNegotiationActivityHistoryLineBeans(List<NegotiationActivity> activities) {
        ArrayList<NegotiationActivityHistoryLineBean> beans = new ArrayList<NegotiationActivityHistoryLineBean>();
        for (NegotiationActivity activity : activities) {
            if (activity.getLocation() == null || activity.getActivityType() == null) continue;
            NegotiationActivityHistoryLineBean bean = new NegotiationActivityHistoryLineBean(activity);
            beans.add(bean);
        }
        Collections.sort(beans);
        Date previousStartDate = null;
        Date previousEndDate = null;
        String previousLocation = "";
        int counter = 1;
        ArrayList<NegotiationActivityHistoryLineBean> beansToReturn = new ArrayList<NegotiationActivityHistoryLineBean>();
        for (NegotiationActivityHistoryLineBean bean : beans) {
            if (StringUtils.equals((String)previousLocation, (String)bean.getLocation())) {
                if (this.isDateBetween(bean.getStartDate(), previousStartDate, previousEndDate) && this.isDateBetween(bean.getEndDate(), previousStartDate, previousEndDate)) {
                    this.setBeanStuff(bean, null, null, "0 Days");
                } else if (this.isDateBetween(bean.getStartDate(), previousStartDate, previousEndDate) && bean.getEndDate().after(previousEndDate)) {
                    Date previousEndDatePlusOneDay = new Date(previousEndDate.getTime() + 86400000L);
                    previousEndDate = bean.getEndDate();
                    this.setBeanStuff(bean, previousEndDatePlusOneDay, bean.getEndDate(), NegotiationActivity.getNumberOfDays((Date)previousEndDatePlusOneDay, (Date)bean.getEndDate()));
                } else {
                    previousStartDate = bean.getStartDate();
                    previousEndDate = bean.getEndDate();
                    this.setBeanStuff(bean, bean.getStartDate(), bean.getEndDate(), NegotiationActivity.getNumberOfDays((Date)bean.getStartDate(), (Date)bean.getEndDate()));
                }
            } else {
                previousStartDate = bean.getStartDate();
                previousEndDate = bean.getEndDate();
                previousLocation = bean.getLocation();
                this.setBeanStuff(bean, bean.getStartDate(), bean.getEndDate(), NegotiationActivity.getNumberOfDays((Date)bean.getStartDate(), (Date)bean.getEndDate()));
                if (!beansToReturn.isEmpty()) {
                    beansToReturn.add(new NegotiationActivityHistoryLineBean());
                }
            }
            bean.setLineNumber(String.valueOf(counter));
            beansToReturn.add(bean);
            ++counter;
        }
        return beansToReturn;
    }

    public List<NegotiationNotification> getNegotiationNotifications(Negotiation negotiation) {
        List<Object> notifications = new ArrayList<NegotiationNotification>();
        if (negotiation.getNegotiationDocument() != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("documentNumber", negotiation.getNegotiationDocument().getDocumentNumber());
            notifications = (List)this.getBusinessObjectService().findMatching(NegotiationNotification.class, fieldValues);
        }
        return notifications;
    }

    private void setBeanStuff(NegotiationActivityHistoryLineBean bean, Date efectiveLocationStartDate, Date efectiveLocationEndDate, String locationDays) {
        bean.setEfectiveLocationEndDate(efectiveLocationEndDate);
        bean.setEfectiveLocationStartDate(efectiveLocationStartDate);
        bean.setLocationDays(locationDays);
    }

    private boolean isDateBetween(Date checkDate, Date rangeStart, Date rangeEnd) {
        if (rangeStart == null) {
            return false;
        }
        if (checkDate == null) {
            checkDate = new Date(Calendar.getInstance().getTimeInMillis());
        }
        if (rangeEnd == null) {
            rangeEnd = new Date(Calendar.getInstance().getTimeInMillis());
        }
        boolean startOk = rangeStart.equals(checkDate) || rangeStart.before(checkDate);
        boolean endOk = rangeEnd.equals(checkDate) || rangeEnd.after(checkDate);
        return startOk && endOk;
    }

    public void promoteProposalLogNegotiation(String proposalLogProposalNumber, String institutionalProposalProposalNumber) {
        Collection negotiations = this.getAssociatedNegotiations(proposalLogProposalNumber, "PL");
        ArrayList<Negotiation> negotiationsToSave = new ArrayList<Negotiation>();
        if (negotiations != null && !negotiations.isEmpty()) {
            NegotiationAssociationType ipAssocationType = this.getNegotiationAssociationType("IP");
            for (Negotiation negotiation : negotiations) {
                negotiation.setNegotiationAssociationType(ipAssocationType);
                negotiation.setNegotiationAssociationTypeId(ipAssocationType.getId());
                negotiation.setAssociatedDocumentId(institutionalProposalProposalNumber);
                negotiationsToSave.add(negotiation);
            }
        }
        this.getBusinessObjectService().save(negotiationsToSave);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public UnitAdministratorDerivedRoleTypeServiceImpl getUnitAdministratorDerivedRoleTypeServiceImpl() {
        return this.unitAdministratorDerivedRoleTypeServiceImpl;
    }

    public void setUnitAdministratorDerivedRoleTypeServiceImpl(UnitAdministratorDerivedRoleTypeServiceImpl unitAdministratorDerivedRoleTypeServiceImpl) {
        this.unitAdministratorDerivedRoleTypeServiceImpl = unitAdministratorDerivedRoleTypeServiceImpl;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

