/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.web.struts.action;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.printing.service.NegotiationPrintingService;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.negotiations.web.struts.form.NegotiationForm;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class NegotiationAction
extends KraTransactionalDocumentActionBase {
    private static final Log LOG = LogFactory.getLog(NegotiationAction.class);
    private NegotiationService negotiationService;
    private SequenceAccessorService sequenceAccessorService;
    private NegotiationPrintingService negotiationPrintingService;
    private KcNotificationService notificationService;
    private KualiRuleService kualiRuleService;

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        NegotiationForm negotiationForm = (NegotiationForm)form;
        this.prepareNegotiation(negotiationForm);
        return forward;
    }

    protected void prepareNegotiation(NegotiationForm negotiationForm) {
        negotiationForm.getCustomDataHelper().prepareCustomData();
        Negotiation negotiation = negotiationForm.getNegotiationDocument().getNegotiation();
        this.getNegotiationService().checkForPropLogPromotion(negotiation);
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        NegotiationDocument negotiationDocument = (NegotiationDocument)kualiDocumentFormBase.getDocument();
        negotiationDocument.getNegotiation().setNegotiationId(this.getSequenceAccessorService().getNextAvailableSequenceNumber("NEGOTIATION_S"));
        negotiationDocument.getNegotiation().setNegotiationStatus(this.getNegotiationService().getNegotiationStatus((String)this.getNegotiationService().getInProgressStatusCodes().get(0)));
        negotiationDocument.getNegotiation().setNegotiationStatusId(negotiationDocument.getNegotiation().getNegotiationStatus().getId());
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        NegotiationForm negotiationForm = (NegotiationForm)form;
        NegotiationDocument negotiationDocument = negotiationForm.getNegotiationDocument();
        if (negotiationDocument.getDocumentHeader().getWorkflowDocument().isInitiated() || negotiationDocument.getDocumentHeader().getWorkflowDocument().isSaved()) {
            this.getDocumentService().routeDocument((Document)negotiationDocument, "Route To Final", new ArrayList());
        }
        actionForward = super.save(mapping, form, request, response);
        return actionForward;
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    protected NegotiationService getNegotiationService() {
        if (this.negotiationService == null) {
            this.negotiationService = (NegotiationService)KraServiceLocator.getService(NegotiationService.class);
        }
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = (SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public NegotiationPrintingService getNegotiationPrintingService() {
        if (this.negotiationPrintingService == null) {
            this.negotiationPrintingService = (NegotiationPrintingService)KraServiceLocator.getService(NegotiationPrintingService.class);
        }
        return this.negotiationPrintingService;
    }

    public void setNegotiationPrintingService(NegotiationPrintingService negotiationPrintingService) {
        this.negotiationPrintingService = negotiationPrintingService;
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    protected KualiRuleService getKualiRuleService() {
        if (this.kualiRuleService == null) {
            this.kualiRuleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
        }
        return this.kualiRuleService;
    }
}

