/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.medusa.MedusaBean;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivityHistoryLineBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociatedDetailBean;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.customdata.CustomDataHelper;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationCloseNotificationContext;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.negotiations.web.struts.form.NegotiationActivityHelper;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.form.CustomDataDocumentForm;
import org.kuali.kra.web.struts.form.KraTransactionalDocumentFormBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationForm
extends KraTransactionalDocumentFormBase
implements CustomDataDocumentForm {
    private static final long serialVersionUID = 6245888664423593163L;
    private static final Log LOG = LogFactory.getLog(NegotiationForm.class);
    private final String filterAllActivities = "All";
    private final String filterPendingActivities = "Pending";
    private List<NegotiationUnassociatedDetail> negotiationUnassociatedDetailsToDelete;
    private NegotiationActivityHelper negotiationActivityHelper;
    private NegotiationAssociatedDetailBean negotiationAssociatedDetailBean;
    private CustomDataHelper negotiationCustomDataFormHelper;
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);
    private NotificationHelper<NegotiationCloseNotificationContext> notificationHelper;
    private String filterActivities = "All";
    private MedusaBean medusaBean;

    public NegotiationForm() {
        this.negotiationUnassociatedDetailsToDelete = new ArrayList();
        this.negotiationActivityHelper = new NegotiationActivityHelper(this);
        this.medusaBean = new MedusaBean();
        this.negotiationCustomDataFormHelper = new CustomDataHelper(this);
        this.notificationHelper = new NotificationHelper();
        this.init();
    }

    private void init() {
        this.getCustomDataHelper().prepareCustomData();
    }

    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public String getDocumentTypeName() {
        return "NegotiationDocument";
    }

    public NegotiationDocument getNegotiationDocument() {
        return (NegotiationDocument)this.getDocument();
    }

    public List<NegotiationUnassociatedDetail> getNegotiationUnassociatedDetailsToDelete() {
        return this.negotiationUnassociatedDetailsToDelete;
    }

    protected String getDefaultDocumentTypeName() {
        return "NegotiationDocument";
    }

    protected String getLockRegion() {
        return "NEGOTIATION";
    }

    protected void setSaveDocumentControl(Map editMode) {
        this.getDocumentActions().put("canSave", "true");
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private Map convertSetToMap(Set s) {
        HashMap map = new HashMap();
        for (Object key : s) {
            map.put(key, "true");
        }
        return map;
    }

    public BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public NegotiationService getNegotiationService() {
        return (NegotiationService)KraServiceLocator.getService(NegotiationService.class);
    }

    private boolean isAssocitationType(String typeCode) {
        if (this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType() != null) {
            return StringUtils.equalsIgnoreCase((String)typeCode, (String)this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType().getCode());
        }
        return false;
    }

    public boolean getDisplayUnAssociatedDetail() {
        return this.isAssocitationType("NO");
    }

    public boolean getDisplayProposalLog() {
        return this.isAssocitationType("PL");
    }

    public boolean getDisplayInstitutionalProposal() {
        return this.isAssocitationType("IP");
    }

    public boolean getDisplayAward() {
        return this.isAssocitationType("AWD");
    }

    public boolean getDisplaySubAward() {
        return this.isAssocitationType("SWD");
    }

    public NegotiationActivityHelper getNegotiationActivityHelper() {
        return this.negotiationActivityHelper;
    }

    public void setNegotiationActivityHelper(NegotiationActivityHelper negotiationActivityHelper) {
        this.negotiationActivityHelper = negotiationActivityHelper;
    }

    public boolean getDispayAssociatedDetailPanel() {
        return !this.getDisplayUnAssociatedDetail() && StringUtils.isNotEmpty((String)this.getNegotiationDocument().getNegotiation().getAssociatedDocumentId());
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        NegotiationDocument nd = this.getNegotiationDocument();
        String ATTRIB_NEG_ID = "DataDictionary.Negotiation.attributes.negotiationId";
        String ATTRIB_NEG_USER_NAME = "DataDictionary.Negotiation.attributes.negotiatorUserName";
        if (nd == null || nd.getNegotiation() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", ""));
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", ""));
            return;
        }
        if (nd.getNegotiation().getNegotiationId() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", ""));
        } else {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", nd.getNegotiation().getNegotiationId().toString()));
        }
        if (nd.getNegotiation().getNegotiatorUserName() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", ""));
        } else {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", nd.getNegotiation().getNegotiatorUserName()));
        }
    }

    public NegotiationAssociatedDetailBean getNegotiationAssociatedDetailBean() {
        Negotiation negotiation = this.getNegotiationDocument().getNegotiation();
        if (this.negotiationAssociatedDetailBean == null || !StringUtils.equals((String)this.negotiationAssociatedDetailBean.getAssociatedDocumentId(), (String)negotiation.getAssociatedDocumentId())) {
            this.negotiationAssociatedDetailBean = this.getNegotiationService().buildNegotiationAssociatedDetailBean(negotiation);
        }
        return this.negotiationAssociatedDetailBean;
    }

    public String getStatusRelatedJavascript() {
        StringBuffer sb = new StringBuffer(100);
        String newLine = "\n ";
        sb.append("function manageStatusEndDate(doUpdateDate){").append(newLine);
        sb.append("var statusField = document.getElementById('document.negotiationList[0].negotiationStatusId');").append(newLine);
        sb.append("var dateField = document.getElementById('document.negotiationList[0].negotiationEndDate');").append(newLine);
        sb.append("var statusFieldSelectedVal = statusField.options[statusField.selectedIndex].value;").append(newLine);
        sb.append("var dateFieldPicker = document.getElementById('document.negotiationList[0].negotiationEndDate_datepicker');").append(newLine);
        sb.append("if (");
        int currentIndex = 0;
        List completedCodes = this.getNegotiationService().getCompletedStatusCodes();
        for (String currentCode : completedCodes) {
            NegotiationStatus currentStatus = this.getNegotiationStatus(currentCode);
            sb.append("statusFieldSelectedVal == '").append(currentStatus.getId().toString()).append("'");
            if (currentIndex + 1 < completedCodes.size()) {
                sb.append(" || ");
            }
            ++currentIndex;
        }
        sb.append(") {").append(newLine);
        sb.append("  dateField.disabled = false;").append(newLine);
        sb.append("  if (dateField.value == '' && doUpdateDate) {").append(newLine);
        sb.append("    var currentTime = new Date();").append(newLine);
        sb.append("    dateField.value = currentTime.getMonth() + 1 + \"/\" +  currentTime.getDate() + \"/\" + currentTime.getFullYear();").append(newLine);
        sb.append("  dateFieldPicker.style.display='inline';").append(newLine);
        sb.append("  }").append(newLine).append("} else {").append(newLine);
        sb.append("  dateField.disabled = true;").append(newLine).append("  dateField.value = '';").append(newLine);
        sb.append("  dateFieldPicker.style.display='none';").append(newLine);
        sb.append("}").append(newLine).append("}").append(newLine);
        sb.append("manageStatusEndDate(false);");
        return sb.toString();
    }

    private NegotiationStatus getNegotiationStatus(String code) {
        return this.getNegotiationService().getNegotiationStatus(code);
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    public String getFilterActivities() {
        return this.filterActivities;
    }

    public void setFilterActivities(String filterActivities) {
        this.filterActivities = filterActivities;
    }

    public List<NegotiationActivityHistoryLineBean> getNegotiationActivityHistoryLineBeans() {
        return this.getNegotiationService().getNegotiationActivityHistoryLineBeans(this.getNegotiationDocument().getNegotiation().getActivities());
    }

    public List<NegotiationNotification> getNegotiationNotifications() {
        return this.getNegotiationService().getNegotiationNotifications(this.getNegotiationDocument().getNegotiation());
    }

    public NotificationHelper<NegotiationCloseNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<NegotiationCloseNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public String getFilterAllActivities() {
        return "All";
    }

    public String getFilterPendingActivities() {
        return "Pending";
    }

    public boolean getDispayChangeAssociatedDocumentWarning() {
        boolean retVal = !StringUtils.isEmpty((String)this.getNegotiationDocument().getNegotiation().getAssociatedDocumentId());
        return retVal;
    }

    public String getDispayChangeAssociatedDocumentWarningMessage() {
        if (this.getDispayChangeAssociatedDocumentWarning() && this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType() != null) {
            StringBuffer sb = new StringBuffer("<div id=\"searchIconDiv\" style=\"display: inline;\" onclick=\"return confirm('");
            String associatedType = this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType().getDescription();
            String docNumber = this.getNegotiationDocument().getNegotiation().getAssociatedNegotiable().getAssociatedDocumentId();
            sb.append("This Negotiation is already associated with ").append(associatedType).append(" number ").append(docNumber);
            sb.append(".  Selecting a different ").append(associatedType).append(" document will disassociate this Negotiation with ");
            sb.append(docNumber).append(".  Are you sure?").append("')\">");
            return sb.toString();
        }
        return "";
    }
}

