/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.rule;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.personmasschange.bo.AwardPersonMassChange;
import org.kuali.kra.personmasschange.bo.InstitutionalProposalPersonMassChange;
import org.kuali.kra.personmasschange.bo.NegotiationPersonMassChange;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.bo.ProposalDevelopmentPersonMassChange;
import org.kuali.kra.personmasschange.bo.SubawardPersonMassChange;
import org.kuali.kra.personmasschange.bo.UnitAdministratorPersonMassChange;
import org.kuali.kra.personmasschange.rule.event.PerformPersonMassChangeEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class PerformPersonMassChangeRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<PerformPersonMassChangeEvent> {
    private static final String REPLACEE_FULL_NAME_FIELD = "document.personMassChange.replaceeFullName";
    private static final String REPLACER_FULL_NAME_FIELD = "document.personMassChange.replacerFullName";
    private static final String AWARD_FIELD = "document.personMassChange.awardPersonMassChange.";
    private static final String INSTITUTIONAL_PROPOSAL_FIELD = "document.personMassChange.institutionalProposalPersonMassChange.";
    private static final String PROPOSAL_DEVELOPMENT_FIELD = "document.personMassChange.proposalDevelopmentPersonMassChange.";
    private static final String SUBAWARD_FIELD = "document.personMassChange.subawardPersonMassChange.";
    private static final String NEGOTIATION_FIELD = "document.personMassChange.negotiationPersonMassChange.";
    private static final String UNIT_ADMINISTRATOR_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.";
    private static final String UNIT_CONTACT_ID = "unitContact";
    private static final String SPONSOR_CONTACT_ID = "sponsorContact";
    private static final String MAILING_INFORMATION_ID = "mailingInformation";
    private static final String IP_REVIEWER_ID = "ipReviewer";
    private static final String REQUISITIONER_ID = "requisitioner";
    private static final String CONTACT_ID = "contact";
    private static final String NEGOTIATOR_ID = "negotiator";
    private static final String ADMINISTRATIVE_OFFICER_ID = "administrativeOfficer";
    private static final String OSP_ADMINISTRATOR_ID = "ospAdministrator";
    private static final String UNIT_HEAD_ID = "unitHead";
    private static final String DEAN_VP_ID = "deanVP";
    private static final String OTHER_INDIVIDUAL_TO_NOTIFY_ID = "otherIndividualToNotify";
    private static final String ADMINISTRATIVE_CONTACT_ID = "administrativeContact";
    private static final String FINANCIAL_CONTACT_ID = "financialContact";
    private static final String AWARD_UNIT_CONTACT_FIELD = "document.personMassChange.awardPersonMassChange.unitContact";
    private static final String AWARD_SPONSOR_CONTACT_FIELD = "document.personMassChange.awardPersonMassChange.sponsorContact";
    private static final String INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_FIELD = "document.personMassChange.institutionalProposalPersonMassChange.unitContact";
    private static final String INSTITUTIONAL_PROPOSAL_MAILING_INFORMATION_FIELD = "document.personMassChange.institutionalProposalPersonMassChange.mailingInformation";
    private static final String INSTITUTIONAL_PROPOSAL_IP_REVIEWER_FIELD = "document.personMassChange.institutionalProposalPersonMassChange.ipReviewer";
    private static final String PROPOSAL_DEVELOPMENT_MAILING_INFORMATION_FIELD = "document.personMassChange.proposalDevelopmentPersonMassChange.mailingInformation";
    private static final String SUBAWARD_REQUISITIONER_FIELD = "document.personMassChange.subawardPersonMassChange.requisitioner";
    private static final String SUBAWARD_CONTACT_FIELD = "document.personMassChange.subawardPersonMassChange.contact";
    private static final String NEGOTIATION_NEGOTIATOR_FIELD = "document.personMassChange.negotiationPersonMassChange.negotiator";
    private static final String UNIT_ADMINISTRATOR_ADMINISTRATIVE_OFFICER_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.administrativeOfficer";
    private static final String UNIT_ADMINISTRATOR_OSP_ADMINISTRATOR_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.ospAdministrator";
    private static final String UNIT_ADMINISTRATOR_UNIT_HEAD_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.unitHead";
    private static final String UNIT_ADMINISTRATOR_DEAN_VP_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.deanVP";
    private static final String UNIT_ADMINISTRATOR_OTHER_INDIVIDUAL_TO_NOTIFY_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.otherIndividualToNotify";
    private static final String UNIT_ADMINISTRATOR_ADMINISTRATIVE_CONTACT_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.administrativeContact";
    private static final String UNIT_ADMINISTRATOR_FINANCIAL_CONTACT_FIELD = "document.personMassChange.unitAdministratorPersonMassChange.financialContact";
    private static final String EMPLOYEE = "Employee";
    private static final String NON_EMPLOYEE = "Non-Employee";
    private static final String AWARD_UNIT_CONTACT = "Award Unit Contact";
    private static final String AWARD_SPONSOR_CONTACT = "Award Sponsor Contact";
    private static final String INSTITUTIONAL_PROPOSAL_MAILING_INFORMATION = "Institutional Proposal Mailing Information";
    private static final String INSTITUTIONAL_PROPOSAL_UNIT_CONTACT = "Institutional Proposal Unit Contact";
    private static final String INSTITUTIONAL_PROPOSAL_IP_REVIEWER = "Institutional Proposal IP Reviewer";
    private static final String PROPOSAL_DEVELOPMENT_MAILING_INFORMATION = "Proposal Development Mailing Information";
    private static final String SUBAWARD_REQUISITIONER = "SubAward Requisitioner";
    private static final String SUBAWARD_CONTACT = "SubAward Contact";
    private static final String NEGOTIATION_NEGOTIATOR = "Negotiation Negotiator";
    private static final String UNIT_ADMINISTRATOR_ADMINISTRATIVE_OFFICER = "Unit Administrator Administrative Officer";
    private static final String UNIT_ADMINISTRATOR_OSP_ADMINISTRATOR = "Unit Administrator OSP Administrator";
    private static final String UNIT_ADMINISTRATOR_UNIT_HEAD = "Unit Administrator Unit Head";
    private static final String UNIT_ADMINISTRATOR_DEAN_VP = "Unit Administrator Dean VP";
    private static final String UNIT_ADMINISTRATOR_OTHER_INDIVIDUAL_TO_NOTIFY = "Unit Administrator Other Individual to Notify";
    private static final String UNIT_ADMINISTRATOR_ADMINISTRATIVE_CONTACT = "Unit Administrator Administrative Contact";
    private static final String UNIT_ADMINISTRATOR_FINANCIAL_CONTACT = "Unit Administrator Financial Contact";

    public boolean processRules(PerformPersonMassChangeEvent event) {
        return this.processPerformMassChangeEvent(event);
    }

    private boolean processPerformMassChangeEvent(PerformPersonMassChangeEvent event) {
        boolean rulePassed = true;
        PersonMassChange personMassChange = event.getPersonMassChange();
        if (rulePassed &= this.validateReplaceeReplacer(personMassChange)) {
            rulePassed &= this.validateAwardMassChange(personMassChange);
            rulePassed &= this.validateInstitutionalProposalMassChange(personMassChange);
            rulePassed &= this.validateProposalDevelopmentMassChange(personMassChange);
            rulePassed &= this.validateSubawardMassChange(personMassChange);
            rulePassed &= this.validateNegotiationMassChange(personMassChange);
            rulePassed &= this.validateUnitAdministratorMassChange(personMassChange);
        }
        return rulePassed;
    }

    private boolean validateReplaceeReplacer(PersonMassChange personMassChange) {
        boolean isValid = true;
        if (personMassChange.getReplaceePersonId() == null && personMassChange.getReplaceeRolodexId() == null) {
            isValid = false;
            this.reportError(REPLACEE_FULL_NAME_FIELD, "error.personMassChange.replacee.empty", new String[0]);
            return isValid;
        }
        if (personMassChange.getReplacerPersonId() == null && personMassChange.getReplacerRolodexId() == null) {
            isValid = false;
            this.reportError(REPLACER_FULL_NAME_FIELD, "error.personMassChange.replacer.empty", new String[0]);
            return isValid;
        }
        if (personMassChange.getReplacerPersonId() != null && StringUtils.equalsIgnoreCase((String)personMassChange.getReplacerPersonId(), (String)personMassChange.getReplaceePersonId()) || personMassChange.getReplacerRolodexId() != null && StringUtils.equalsIgnoreCase((String)String.valueOf(personMassChange.getReplacerRolodexId()), (String)String.valueOf(personMassChange.getReplaceeRolodexId()))) {
            isValid = false;
            this.reportError(REPLACER_FULL_NAME_FIELD, "error.personMassChange.person.same", new String[0]);
        }
        return isValid;
    }

    private boolean validateAwardMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        AwardPersonMassChange awardPersonMassChange = personMassChange.getAwardPersonMassChange();
        if (awardPersonMassChange.isUnitContact()) {
            isValid &= this.validatePerson(personMassChange, AWARD_UNIT_CONTACT_FIELD, AWARD_UNIT_CONTACT);
        }
        if (awardPersonMassChange.isSponsorContact()) {
            isValid &= this.validateRolodex(personMassChange, AWARD_SPONSOR_CONTACT_FIELD, AWARD_SPONSOR_CONTACT);
        }
        return isValid;
    }

    private boolean validateInstitutionalProposalMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        InstitutionalProposalPersonMassChange institutionalProposalPersonMassChange = personMassChange.getInstitutionalProposalPersonMassChange();
        if (institutionalProposalPersonMassChange.isMailingInformation()) {
            isValid &= this.validateRolodex(personMassChange, INSTITUTIONAL_PROPOSAL_MAILING_INFORMATION_FIELD, INSTITUTIONAL_PROPOSAL_MAILING_INFORMATION);
        }
        if (institutionalProposalPersonMassChange.isUnitContact()) {
            isValid &= this.validatePerson(personMassChange, INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_FIELD, INSTITUTIONAL_PROPOSAL_UNIT_CONTACT);
        }
        if (institutionalProposalPersonMassChange.isIpReviewer()) {
            isValid &= this.validatePerson(personMassChange, INSTITUTIONAL_PROPOSAL_IP_REVIEWER_FIELD, INSTITUTIONAL_PROPOSAL_IP_REVIEWER);
        }
        return isValid;
    }

    private boolean validateProposalDevelopmentMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        ProposalDevelopmentPersonMassChange proposalDevelopmentPersonMassChange = personMassChange.getProposalDevelopmentPersonMassChange();
        if (proposalDevelopmentPersonMassChange.isMailingInformation()) {
            isValid &= this.validateRolodex(personMassChange, PROPOSAL_DEVELOPMENT_MAILING_INFORMATION_FIELD, PROPOSAL_DEVELOPMENT_MAILING_INFORMATION);
        }
        return isValid;
    }

    private boolean validateSubawardMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        SubawardPersonMassChange subawardPersonMassChange = personMassChange.getSubawardPersonMassChange();
        if (subawardPersonMassChange.isContact()) {
            isValid &= this.validateRolodex(personMassChange, SUBAWARD_CONTACT_FIELD, SUBAWARD_CONTACT);
        }
        if (subawardPersonMassChange.isRequisitioner()) {
            isValid &= this.validatePerson(personMassChange, SUBAWARD_REQUISITIONER_FIELD, SUBAWARD_REQUISITIONER);
        }
        return isValid;
    }

    private boolean validateNegotiationMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        NegotiationPersonMassChange negotiationPersonMassChange = personMassChange.getNegotiationPersonMassChange();
        if (negotiationPersonMassChange.isNegotiator()) {
            isValid &= this.validatePerson(personMassChange, NEGOTIATION_NEGOTIATOR_FIELD, NEGOTIATION_NEGOTIATOR);
        }
        return isValid;
    }

    private boolean validateUnitAdministratorMassChange(PersonMassChange personMassChange) {
        boolean isValid = true;
        UnitAdministratorPersonMassChange unitPersonMassChange = personMassChange.getUnitAdministratorPersonMassChange();
        if (unitPersonMassChange.isAdministrativeOfficer()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_ADMINISTRATIVE_OFFICER_FIELD, UNIT_ADMINISTRATOR_ADMINISTRATIVE_OFFICER);
        }
        if (unitPersonMassChange.isOspAdministrator()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_OSP_ADMINISTRATOR_FIELD, UNIT_ADMINISTRATOR_OSP_ADMINISTRATOR);
        }
        if (unitPersonMassChange.isUnitHead()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_UNIT_HEAD_FIELD, UNIT_ADMINISTRATOR_UNIT_HEAD);
        }
        if (unitPersonMassChange.isDeanVP()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_DEAN_VP_FIELD, UNIT_ADMINISTRATOR_DEAN_VP);
        }
        if (unitPersonMassChange.isOtherIndividualToNotify()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_OTHER_INDIVIDUAL_TO_NOTIFY_FIELD, UNIT_ADMINISTRATOR_OTHER_INDIVIDUAL_TO_NOTIFY);
        }
        if (unitPersonMassChange.isAdministrativeContact()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_ADMINISTRATIVE_CONTACT_FIELD, UNIT_ADMINISTRATOR_ADMINISTRATIVE_CONTACT);
        }
        if (unitPersonMassChange.isFinancialContact()) {
            isValid &= this.validatePerson(personMassChange, UNIT_ADMINISTRATOR_FINANCIAL_CONTACT_FIELD, UNIT_ADMINISTRATOR_FINANCIAL_CONTACT);
        }
        return isValid;
    }

    private boolean validatePerson(PersonMassChange personMassChange, String propertyName, String typeText) {
        boolean isValid = true;
        if (!this.isReplaceePerson(personMassChange.getReplaceePersonId(), personMassChange.getReplaceeRolodexId())) {
            isValid = false;
            this.reportError(propertyName, "error.personMassChange.replacee.selection", new String[]{NON_EMPLOYEE, typeText});
        }
        if (!this.isReplacerPerson(personMassChange.getReplacerPersonId(), personMassChange.getReplacerRolodexId())) {
            isValid = false;
            this.reportError(propertyName, "error.personMassChange.replacer.selection", new String[]{typeText, NON_EMPLOYEE});
        }
        return isValid;
    }

    private boolean validateRolodex(PersonMassChange personMassChange, String propertyName, String typeText) {
        boolean isValid = true;
        if (!this.isReplaceeRolodex(personMassChange.getReplaceePersonId(), personMassChange.getReplaceeRolodexId())) {
            isValid = false;
            this.reportError(propertyName, "error.personMassChange.replacee.selection", new String[]{EMPLOYEE, typeText});
        }
        if (!this.isReplacerRolodex(personMassChange.getReplacerPersonId(), personMassChange.getReplacerRolodexId())) {
            isValid = false;
            this.reportError(propertyName, "error.personMassChange.replacer.selection", new String[]{typeText, EMPLOYEE});
        }
        return isValid;
    }

    private boolean isReplaceePerson(String replaceePersonId, Integer replaceeRolodexId) {
        return replaceePersonId != null && replaceeRolodexId == null;
    }

    private boolean isReplaceeRolodex(String replaceePersonId, Integer replaceeRolodexId) {
        return replaceePersonId == null && replaceeRolodexId != null;
    }

    private boolean isReplacerPerson(String replacerPersonId, Integer replacerRolodexId) {
        return replacerPersonId != null && replacerRolodexId == null;
    }

    private boolean isReplacerRolodex(String replacerPersonId, Integer replacerRolodexId) {
        return replacerPersonId == null && replacerRolodexId != null;
    }
}

