/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.AwardPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements AwardPersonMassChangeService {
    public static final String AWARD_WARNINGS = "awardWarnings";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String AWARD = "award";

    public List<Award> getAwardChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<Award> awardChangeCandidates = new ArrayList<Award>();
        ArrayList awards = new ArrayList();
        if (personMassChange.getAwardPersonMassChange().requiresChange()) {
            awards.addAll(this.getAwards(personMassChange));
        }
        for (Award award : awards) {
            if (!this.isAwardChangeCandidate(personMassChange, award)) continue;
            awardChangeCandidates.add(award);
        }
        for (Award awardChangeCandidate : awardChangeCandidates) {
            if (awardChangeCandidate.getAwardDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(awardChangeCandidate);
        }
        return awardChangeCandidates;
    }

    private List<Award> getAwards(PersonMassChange personMassChange) {
        ArrayList<Award> awards = new ArrayList<Award>();
        Collection allAwards = this.getBusinessObjectService().findAll(Award.class);
        if (personMassChange.isChangeAllSequences()) {
            awards.addAll(allAwards);
        } else {
            awards.addAll(this.getLatestAwards(allAwards));
        }
        return awards;
    }

    private List<Award> getLatestAwards(Collection<Award> awards) {
        ArrayList<Award> latestAwards = new ArrayList<Award>();
        for (String uniqueAwardNumber : this.getUniqueAwardNumbers(awards)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(AWARD_NUMBER, uniqueAwardNumber);
            Collection uniqueAwards = this.getBusinessObjectService().findMatchingOrderBy(Award.class, fieldValues, SEQUENCE_NUMBER, false);
            if (uniqueAwards.isEmpty()) continue;
            latestAwards.add((Award)CollectionUtils.get((Object)uniqueAwards, (int)0));
        }
        return latestAwards;
    }

    private Set<String> getUniqueAwardNumbers(Collection<Award> awards) {
        HashSet<String> uniqueAwardIds = new HashSet<String>();
        for (Award award : awards) {
            uniqueAwardIds.add(award.getAwardNumber());
        }
        return uniqueAwardIds;
    }

    private boolean isAwardChangeCandidate(PersonMassChange personMassChange, Award award) {
        boolean isAwardChangeCandidate = false;
        boolean hasErrors = false;
        List persons = award.getProjectPersons();
        List sponsorContacts = award.getSponsorContacts();
        List approvedForeignTravels = award.getApprovedForeignTravelTrips();
        List unitContacts = award.getAwardUnitContacts();
        String[] investigatorRoles = new String[]{"PI", "COI"};
        String[] keyStudyPersonRoles = new String[]{"KP"};
        if (personMassChange.getAwardPersonMassChange().isInvestigator()) {
            isAwardChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, investigatorRoles);
        }
        if (personMassChange.getAwardPersonMassChange().isKeyStudyPerson()) {
            isAwardChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, keyStudyPersonRoles);
        }
        if (isAwardChangeCandidate) {
            hasErrors |= !this.isReplacerValidPersonChangeCandidate(personMassChange, persons);
        }
        if (personMassChange.getAwardPersonMassChange().isUnitContact()) {
            isAwardChangeCandidate |= this.isUnitContactChangeCandidate(personMassChange, unitContacts);
        }
        if (personMassChange.getAwardPersonMassChange().isSponsorContact()) {
            isAwardChangeCandidate |= this.isSponsorContactChangeCandidate(personMassChange, sponsorContacts);
        }
        if (personMassChange.getAwardPersonMassChange().isApprovedForeignTravel()) {
            isAwardChangeCandidate |= this.isApprovedForeignTravelChangeCandidate(personMassChange, approvedForeignTravels);
        }
        return isAwardChangeCandidate && !hasErrors;
    }

    private boolean isUnitContactChangeCandidate(PersonMassChange personMassChange, List<AwardUnitContact> unitContacts) {
        boolean isUnitContactChangeCandidate = false;
        for (AwardUnitContact unitContact : unitContacts) {
            if (!this.isPersonIdMassChange(personMassChange, unitContact.getPersonId())) continue;
            isUnitContactChangeCandidate = true;
            break;
        }
        return isUnitContactChangeCandidate;
    }

    private boolean isSponsorContactChangeCandidate(PersonMassChange personMassChange, List<AwardSponsorContact> sponsorContacts) {
        boolean isSponsorContactChangeCandidate = false;
        for (AwardSponsorContact sponsorContact : sponsorContacts) {
            if (!this.isRolodexIdMassChange(personMassChange, sponsorContact.getRolodexId())) continue;
            isSponsorContactChangeCandidate = true;
            break;
        }
        return isSponsorContactChangeCandidate;
    }

    private boolean isApprovedForeignTravelChangeCandidate(PersonMassChange personMassChange, List<AwardApprovedForeignTravel> approvedForeignTravels) {
        boolean isApprovedForeignTravelChangeCandidate = false;
        for (AwardApprovedForeignTravel approvedForeignTravel : approvedForeignTravels) {
            if (!this.isPersonIdMassChange(personMassChange, approvedForeignTravel.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, approvedForeignTravel.getRolodexId())) continue;
            isApprovedForeignTravelChangeCandidate = true;
            break;
        }
        return isApprovedForeignTravelChangeCandidate;
    }

    public void performPersonMassChange(PersonMassChange personMassChange, List<Award> awardChangeCandidates) {
        for (Award awardChangeCandidate : awardChangeCandidates) {
            if (!awardChangeCandidate.getAwardDocument().getPessimisticLocks().isEmpty()) continue;
            this.performInvestigatorPersonMassChange(personMassChange, awardChangeCandidate);
            this.performKeyStudyPersonPersonMassChange(personMassChange, awardChangeCandidate);
            this.performUnitContactPersonMassChange(personMassChange, awardChangeCandidate);
            this.performSponsorContactPersonMassChange(personMassChange, awardChangeCandidate);
            this.performApprovedForeignTravelPersonMassChange(personMassChange, awardChangeCandidate);
        }
    }

    private void performInvestigatorPersonMassChange(PersonMassChange personMassChange, Award award) {
        if (personMassChange.getAwardPersonMassChange().isInvestigator()) {
            String[] personRoles = new String[]{"PI", "COI"};
            this.performPersonPersonMassChange(personMassChange, award, personRoles);
        }
    }

    private void performKeyStudyPersonPersonMassChange(PersonMassChange personMassChange, Award award) {
        if (personMassChange.getAwardPersonMassChange().isKeyStudyPerson()) {
            String[] personRoles = new String[]{"KP"};
            this.performPersonPersonMassChange(personMassChange, award, personRoles);
        }
    }

    private void performPersonPersonMassChange(PersonMassChange personMassChange, Award award, String ... personRoles) {
        for (AwardPerson person : award.getProjectPersons()) {
            if (!this.isPersonInRole((AbstractProjectPerson)person, personRoles) || !this.isPersonIdMassChange(personMassChange, person.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, person.getRolodexId())) continue;
            if (personMassChange.getReplacerPersonId() != null) {
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                person.setPersonId(kcPerson.getPersonId());
                person.setRolodexId(null);
                person.setFullName(kcPerson.getFullName());
            } else if (personMassChange.getReplacerRolodexId() != null) {
                Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId().intValue());
                person.setPersonId(null);
                person.setRolodexId(rolodex.getRolodexId());
                person.setFullName(rolodex.getFullName());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)person);
        }
    }

    private void performUnitContactPersonMassChange(PersonMassChange personMassChange, Award award) {
        if (personMassChange.getAwardPersonMassChange().isUnitContact()) {
            for (AwardUnitContact unitContact : award.getAwardUnitContacts()) {
                if (!this.isPersonIdMassChange(personMassChange, unitContact.getPersonId())) continue;
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                unitContact.setPersonId(kcPerson.getPersonId());
                unitContact.setFullName(kcPerson.getFullName());
                this.getBusinessObjectService().save((PersistableBusinessObject)unitContact);
            }
        }
    }

    private void performSponsorContactPersonMassChange(PersonMassChange personMassChange, Award award) {
        if (personMassChange.getAwardPersonMassChange().isSponsorContact()) {
            for (AwardSponsorContact sponsorContact : award.getSponsorContacts()) {
                if (!this.isRolodexIdMassChange(personMassChange, sponsorContact.getRolodexId())) continue;
                sponsorContact.setRolodexId(personMassChange.getReplacerRolodexId());
                this.getBusinessObjectService().save((PersistableBusinessObject)sponsorContact);
            }
        }
    }

    private void performApprovedForeignTravelPersonMassChange(PersonMassChange personMassChange, Award award) {
        if (personMassChange.getAwardPersonMassChange().isApprovedForeignTravel()) {
            for (AwardApprovedForeignTravel approvedForeignTravel : award.getApprovedForeignTravelTrips()) {
                if (!this.isPersonIdMassChange(personMassChange, approvedForeignTravel.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, approvedForeignTravel.getRolodexId())) continue;
                if (personMassChange.getReplacerPersonId() != null) {
                    KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                    approvedForeignTravel.setPersonId(kcPerson.getPersonId());
                    approvedForeignTravel.setTravelerName(kcPerson.getFullName());
                    approvedForeignTravel.setRolodexId(null);
                } else if (personMassChange.getReplacerRolodexId() != null) {
                    Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId().intValue());
                    approvedForeignTravel.setPersonId(null);
                    approvedForeignTravel.setRolodexId(rolodex.getRolodexId());
                    approvedForeignTravel.setTravelerName(rolodex.getFullName());
                }
                this.getBusinessObjectService().save((PersistableBusinessObject)approvedForeignTravel);
            }
        }
    }

    private void reportSoftError(Award award) {
        String awardNumber = award.getAwardNumber();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", new String[]{AWARD, awardNumber});
    }

    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((Award)parent).getAwardNumber();
    }

    protected String getDocumentName() {
        return AWARD;
    }

    protected String getWarningKey() {
        return AWARD_WARNINGS;
    }
}

