/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.InstitutionalProposalPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class InstitutionalProposalPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements InstitutionalProposalPersonMassChangeService {
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String INSTITUTIONAL_PROPOSAL = "institutional proposal";
    private static final String INSTPROP_WARNINGS = "instPropWarnings";

    public List<InstitutionalProposal> getInstitutionalProposalChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<InstitutionalProposal> institutionalProposalChangeCandidates = new ArrayList<InstitutionalProposal>();
        ArrayList institutionalProposals = new ArrayList();
        if (personMassChange.getInstitutionalProposalPersonMassChange().requiresChange()) {
            institutionalProposals.addAll(this.getInstitutionalProposals(personMassChange));
        }
        for (InstitutionalProposal institutionalProposal : institutionalProposals) {
            if (!this.isInstitutionalProposalChangeCandidate(personMassChange, institutionalProposal)) continue;
            institutionalProposalChangeCandidates.add(institutionalProposal);
        }
        for (InstitutionalProposal institutionalProposalChangeCandidate : institutionalProposalChangeCandidates) {
            if (institutionalProposalChangeCandidate.getInstitutionalProposalDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(institutionalProposalChangeCandidate);
        }
        return institutionalProposalChangeCandidates;
    }

    private List<InstitutionalProposal> getInstitutionalProposals(PersonMassChange personMassChange) {
        ArrayList<InstitutionalProposal> institutionalProposals = new ArrayList<InstitutionalProposal>();
        Collection allInstitutionalProposals = this.getBusinessObjectService().findAll(InstitutionalProposal.class);
        if (personMassChange.isChangeAllSequences()) {
            institutionalProposals.addAll(allInstitutionalProposals);
        } else {
            institutionalProposals.addAll(this.getLatestInstitutionalProposals(allInstitutionalProposals));
        }
        return institutionalProposals;
    }

    private List<InstitutionalProposal> getLatestInstitutionalProposals(Collection<InstitutionalProposal> institutionalProposals) {
        ArrayList<InstitutionalProposal> latestInstitutionalProposals = new ArrayList<InstitutionalProposal>();
        for (String uniqueInstitutionalProposalNumber : this.getUniqueInstitutionalProposalNumbers(institutionalProposals)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(PROPOSAL_NUMBER, uniqueInstitutionalProposalNumber);
            Collection uniqueInstitutionalProposals = this.getBusinessObjectService().findMatchingOrderBy(InstitutionalProposal.class, fieldValues, SEQUENCE_NUMBER, false);
            if (uniqueInstitutionalProposals.isEmpty()) continue;
            latestInstitutionalProposals.add((InstitutionalProposal)CollectionUtils.get((Object)uniqueInstitutionalProposals, (int)0));
        }
        return latestInstitutionalProposals;
    }

    private Set<String> getUniqueInstitutionalProposalNumbers(Collection<InstitutionalProposal> institutionalProposals) {
        HashSet<String> uniqueAwardIds = new HashSet<String>();
        for (InstitutionalProposal institutionalProposal : institutionalProposals) {
            uniqueAwardIds.add(institutionalProposal.getProposalNumber());
        }
        return uniqueAwardIds;
    }

    private boolean isInstitutionalProposalChangeCandidate(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        boolean isInstitutionalProposalChangeCandidate = false;
        boolean hasErrors = false;
        List persons = institutionalProposal.getProjectPersons();
        Integer mailingInformationId = institutionalProposal.getRolodexId();
        List unitContacts = institutionalProposal.getInstitutionalProposalUnitContacts();
        IntellectualPropertyReview intellectualPropertyReview = institutionalProposal.getProposalIpReviewJoin().getIntellectualPropertyReview();
        String[] investigatorRoles = new String[]{"PI", "COI"};
        String[] keyStudyPersonRoles = new String[]{"KP"};
        if (personMassChange.getInstitutionalProposalPersonMassChange().isInvestigator()) {
            isInstitutionalProposalChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, investigatorRoles);
        }
        if (personMassChange.getInstitutionalProposalPersonMassChange().isKeyStudyPerson()) {
            isInstitutionalProposalChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, keyStudyPersonRoles);
        }
        if (isInstitutionalProposalChangeCandidate) {
            hasErrors |= !this.isReplacerValidPersonChangeCandidate(personMassChange, persons);
        }
        if (personMassChange.getInstitutionalProposalPersonMassChange().isMailingInformation()) {
            isInstitutionalProposalChangeCandidate |= this.isMailingInformationChangeCandidate(personMassChange, mailingInformationId);
        }
        if (personMassChange.getInstitutionalProposalPersonMassChange().isUnitContact()) {
            isInstitutionalProposalChangeCandidate |= this.isUnitContactChangeCandidate(personMassChange, unitContacts);
        }
        if (personMassChange.getInstitutionalProposalPersonMassChange().isIpReviewer()) {
            isInstitutionalProposalChangeCandidate |= this.isIpReviewerChangeCandidate(personMassChange, intellectualPropertyReview);
        }
        return isInstitutionalProposalChangeCandidate && !hasErrors;
    }

    private boolean isMailingInformationChangeCandidate(PersonMassChange personMassChange, Integer mailingInformation) {
        return this.isRolodexIdMassChange(personMassChange, mailingInformation);
    }

    private boolean isUnitContactChangeCandidate(PersonMassChange personMassChange, List<InstitutionalProposalUnitContact> unitContacts) {
        boolean isUnitContactChangeCandidate = false;
        for (InstitutionalProposalUnitContact unitContact : unitContacts) {
            if (!this.isPersonIdMassChange(personMassChange, unitContact.getPersonId())) continue;
            isUnitContactChangeCandidate = true;
            break;
        }
        return isUnitContactChangeCandidate;
    }

    private boolean isIpReviewerChangeCandidate(PersonMassChange personMassChange, IntellectualPropertyReview intellectualPropertyReview) {
        boolean isIpReviewerChangeCandidate = false;
        if (intellectualPropertyReview != null) {
            isIpReviewerChangeCandidate = this.isPersonIdMassChange(personMassChange, intellectualPropertyReview.getIpReviewer());
        }
        return isIpReviewerChangeCandidate;
    }

    public void performPersonMassChange(PersonMassChange personMassChange, List<InstitutionalProposal> institutionalProposalChangeCandidates) {
        for (InstitutionalProposal institutionalProposalChangeCandidate : institutionalProposalChangeCandidates) {
            if (!institutionalProposalChangeCandidate.getInstitutionalProposalDocument().getPessimisticLocks().isEmpty()) continue;
            this.performInvestigatorPersonMassChange(personMassChange, institutionalProposalChangeCandidate);
            this.performKeyStudyPersonPersonMassChange(personMassChange, institutionalProposalChangeCandidate);
            this.performMailingInformationPersonMassChange(personMassChange, institutionalProposalChangeCandidate);
            this.performUnitContactPersonMassChange(personMassChange, institutionalProposalChangeCandidate);
            this.performIpReviewerPersonMassChange(personMassChange, institutionalProposalChangeCandidate);
        }
    }

    private void performInvestigatorPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        if (personMassChange.getInstitutionalProposalPersonMassChange().isInvestigator()) {
            String[] personRoles = new String[]{"PI", "COI"};
            this.performPersonPersonMassChange(personMassChange, institutionalProposal, personRoles);
        }
    }

    private void performKeyStudyPersonPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        if (personMassChange.getInstitutionalProposalPersonMassChange().isKeyStudyPerson()) {
            String[] personRoles = new String[]{"KP"};
            this.performPersonPersonMassChange(personMassChange, institutionalProposal, personRoles);
        }
    }

    private void performPersonPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal, String ... personRoles) {
        for (InstitutionalProposalPerson person : institutionalProposal.getProjectPersons()) {
            if (!this.isPersonInRole((AbstractProjectPerson)person, personRoles) || !this.isPersonIdMassChange(personMassChange, person.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, person.getRolodexId())) continue;
            if (personMassChange.getReplacerPersonId() != null) {
                person.setPersonId(personMassChange.getReplacerPersonId());
            } else if (personMassChange.getReplacerRolodexId() != null) {
                person.setRolodexId(personMassChange.getReplacerRolodexId());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)person);
        }
    }

    private void performMailingInformationPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        if (personMassChange.getInstitutionalProposalPersonMassChange().isMailingInformation()) {
            Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId().intValue());
            institutionalProposal.setRolodexId(rolodex.getRolodexId());
            this.getBusinessObjectService().save((PersistableBusinessObject)institutionalProposal);
        }
    }

    private void performUnitContactPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        if (personMassChange.getInstitutionalProposalPersonMassChange().isUnitContact()) {
            for (InstitutionalProposalUnitContact unitContact : institutionalProposal.getInstitutionalProposalUnitContacts()) {
                if (!this.isPersonIdMassChange(personMassChange, unitContact.getPersonId())) continue;
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                unitContact.setPersonId(kcPerson.getPersonId());
                unitContact.setFullName(kcPerson.getFullName());
                this.getBusinessObjectService().save((PersistableBusinessObject)unitContact);
            }
        }
    }

    private void performIpReviewerPersonMassChange(PersonMassChange personMassChange, InstitutionalProposal institutionalProposal) {
        IntellectualPropertyReview intellectualPropertyReview;
        if (personMassChange.getInstitutionalProposalPersonMassChange().isIpReviewer() && (intellectualPropertyReview = institutionalProposal.getProposalIpReviewJoin().getIntellectualPropertyReview()) != null) {
            KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
            intellectualPropertyReview.setIpReviewer(kcPerson.getPersonId());
            this.getBusinessObjectService().save((PersistableBusinessObject)intellectualPropertyReview);
        }
    }

    private void reportSoftError(InstitutionalProposal institutionalProposal) {
        String proposalNumber = institutionalProposal.getProposalNumber();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", new String[]{INSTITUTIONAL_PROPOSAL, proposalNumber});
    }

    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((InstitutionalProposal)parent).getProposalNumber();
    }

    protected String getDocumentName() {
        return INSTITUTIONAL_PROPOSAL;
    }

    protected String getWarningKey() {
        return INSTPROP_WARNINGS;
    }
}

