/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class MassPersonChangeServiceBase {
    protected static final String PMC_LOCKED_FIELD = "personMassChangeDocumentLocked";
    protected final ErrorReporter errorReporter = new ErrorReporter();
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;
    private RolodexService rolodexService;

    protected boolean isReplacerValidPersonChangeCandidate(PersonMassChange personMassChange, List<? extends AbstractProjectPerson> persons) {
        boolean isValid = true;
        for (AbstractProjectPerson abstractProjectPerson : persons) {
            if ((personMassChange.getReplacerPersonId() == null || !StringUtils.equals((String)personMassChange.getReplacerPersonId(), (String)abstractProjectPerson.getPersonId())) && (personMassChange.getReplacerRolodexId() == null || !ObjectUtils.equals((Object)personMassChange.getReplacerRolodexId(), (Object)abstractProjectPerson.getRolodexId()))) continue;
            this.reportReplacerExists(abstractProjectPerson);
            isValid = false;
        }
        return isValid;
    }

    protected boolean isPersonChangeCandidate(PersonMassChange personMassChange, List<? extends AbstractProjectPerson> persons, String ... personRoles) {
        boolean isPersonChangeCandidate = false;
        for (AbstractProjectPerson abstractProjectPerson : persons) {
            if (!this.isPersonInRole(abstractProjectPerson, personRoles) || !this.isPersonIdMassChange(personMassChange, abstractProjectPerson.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, abstractProjectPerson.getRolodexId())) continue;
            isPersonChangeCandidate = true;
            break;
        }
        return isPersonChangeCandidate;
    }

    protected boolean isPersonInRole(AbstractProjectPerson person, String ... personRoles) {
        boolean isPersonInRole = false;
        for (String personRole : personRoles) {
            if (!StringUtils.equals((String)person.getRoleCode(), (String)personRole)) continue;
            isPersonInRole = true;
            break;
        }
        return isPersonInRole;
    }

    protected boolean isPersonIdMassChange(PersonMassChange personMassChange, String personId) {
        String replaceePersonId = personMassChange.getReplaceePersonId();
        return replaceePersonId != null && replaceePersonId.equals(personId);
    }

    protected boolean isRolodexIdMassChange(PersonMassChange personMassChange, Integer rolodexId) {
        Integer replaceeRolodexId = personMassChange.getReplaceeRolodexId();
        return replaceeRolodexId != null && replaceeRolodexId.equals(rolodexId);
    }

    protected void reportReplacerExists(AbstractProjectPerson person) {
        this.errorReporter.reportWarning(this.getWarningKey(), "error.personMassChange.replacer.exists", new String[]{this.getDocumentName(), this.getDocumentId(person.getParent()), person.getFullName()});
    }

    protected abstract String getWarningKey();

    protected abstract String getDocumentName();

    protected abstract String getDocumentId(PersistableBusinessObject var1);

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}

